
dnl FDO_HELP_STRING(LHS, RHS)
dnl Autoconf 2.50 can not handle substr correctly.  It does have 
dnl AC_HELP_STRING, so let's try to call it if we can.
dnl Note: this define must be on one line so that it can be properly returned
dnl as the help string.
AC_DEFUN(FDO_HELP_STRING,[ifelse(regexp(AC_ACVERSION, 2\.1), -1, AC_HELP_STRING($1,$2),[  ]$1 substr([                       ],len($1))$2)])dnl

dnl FDO_SUBST(VARIABLE)
dnl Makes VARIABLE available in generated files
dnl (do not use @variable@ in Makefiles, but $(variable))
AC_DEFUN(FDO_SUBST,[
  FDO_VAR_SUBST="$FDO_VAR_SUBST $1"
  AC_SUBST($1)
])

dnl FDO_FAST_OUTPUT(FILENAME)
dnl Perform substitutions on FILENAME (Makefiles only)
AC_DEFUN(FDO_FAST_OUTPUT,[
  FDO_FAST_OUTPUT_FILES="$FDO_FAST_OUTPUT_FILES $1"
])

dnl FDO_GEN_CONFIG_VARS
dnl Creates config_vars.mk
AC_DEFUN(FDO_GEN_CONFIG_VARS,[
  FDO_SUBST(bindir)
  FDO_SUBST(sbindir)
  FDO_SUBST(phpdir)
  FDO_SUBST(logfiledir)
  FDO_SUBST(libdir)
  FDO_SUBST(libexecdir)
  FDO_SUBST(htdocsdir)
  FDO_SUBST(includedir)
  FDO_SUBST(installbuilddir)
  FDO_SUBST(runtimedir)
  FDO_SUBST(other_targets)
  FDO_SUBST(progname)
  FDO_SUBST(prefix)
  FDO_SUBST(AWK)
  FDO_SUBST(CC)
  FDO_SUBST(CPP)
  FDO_SUBST(CXX)
  FDO_SUBST(CPPFLAGS)
  FDO_SUBST(CFLAGS)
  FDO_SUBST(CXXFLAGS)
  FDO_SUBST(LTFLAGS)
  FDO_SUBST(LDFLAGS)
  FDO_SUBST(LT_LDFLAGS)
  FDO_SUBST(SH_LDFLAGS)
  FDO_SUBST(LIBS)
  FDO_SUBST(DEFS)
  FDO_SUBST(INCLUDES)
  FDO_SUBST(LIBTOOL)
  abs_srcdir="`(cd $srcdir && pwd)`"
 echo creating config_vars.mk
  test -d build || $mkdir_p build
  > config_vars.mk
  for i in $FDO_VAR_SUBST; do
    eval echo "$i = \$$i" >> config_vars.mk
  done
])

dnl # 
dnl # FDO_GENERATE_MAKEFILES
dnl # Creates Makefiles
AC_DEFUN(FDO_GENERATE_MAKEFILES,[
  $SHELL $srcdir/fastgen.sh $srcdir $ac_cv_mkdir_p $FDO_FAST_OUTPUT_FILES
])

dnl ## FDO_OUTPUT(file)
dnl ## adds "file" to the list of files generated by AC_OUTPUT
dnl ## This macro can be used several times.
AC_DEFUN(FDO_OUTPUT, [
  FDO_OUTPUT_FILES="$FDO_OUTPUT_FILES $1"
])

dnl
dnl FDO_DEFINE_TYPE_RLIM_T
dnl
dnl If rlim_t is not defined, define it to int
dnl
AC_DEFUN(FDO_DEFINE_TYPE_RLIM_T, [
  AC_CACHE_CHECK([for rlim_t], ac_cv_type_rlim_t, [
    AC_TRY_COMPILE([
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
], [rlim_t spoon;], [
      ac_cv_type_rlim_t=yes
    ],[ac_cv_type_rlim_t=no
    ])
  ])
  if test "$ac_cv_type_rlim_t" = "no" ; then
      AC_DEFINE(rlim_t, int,
          [Define to 'int' if <sys/resource.h> doesn't define it for us])
  fi
])



dnl NOT YET IMPLEMENTED
dnl FDO_EXPORT_ARGUMENTS
dnl Export (via FDO_SUBST) the various path-related variables that
dnl Autodesk MapGuide Open Source will use while generating scripts
dnl like autoconf and the default config file.

AC_DEFUN(FDO_SUBST_EXPANDED_ARG,[
  APR_EXPAND_VAR(exp_$1, [$]$1)
  FDO_SUBST(exp_$1)
  APR_PATH_RELATIVE(rel_$1, [$]exp_$1, ${prefix})
  FDO_SUBST(rel_$1)
])

AC_DEFUN(FDO_EXPORT_ARGUMENTS,[
  FDO_SUBST_EXPANDED_ARG(exec_prefix)
  FDO_SUBST_EXPANDED_ARG(bindir)
  FDO_SUBST_EXPANDED_ARG(sbindir)
  FDO_SUBST_EXPANDED_ARG(libdir)
  FDO_SUBST_EXPANDED_ARG(libexecdir)
  FDO_SUBST_EXPANDED_ARG(mandir)
  FDO_SUBST_EXPANDED_ARG(sysconfdir)
  FDO_SUBST_EXPANDED_ARG(datadir)
  FDO_SUBST_EXPANDED_ARG(installbuilddir)
  FDO_SUBST_EXPANDED_ARG(errordir)
  FDO_SUBST_EXPANDED_ARG(iconsdir)
  FDO_SUBST_EXPANDED_ARG(htdocsdir)
  FDO_SUBST_EXPANDED_ARG(manualdir)
  FDO_SUBST_EXPANDED_ARG(cgidir)
  FDO_SUBST_EXPANDED_ARG(includedir)
  FDO_SUBST_EXPANDED_ARG(localstatedir)
  FDO_SUBST_EXPANDED_ARG(runtimedir)
  FDO_SUBST_EXPANDED_ARG(logfiledir)
  FDO_SUBST_EXPANDED_ARG(proxycachedir)
])

