/************************************************************************
/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
* Name																	*
*	mysql_get_gen_id - Gets the last value generated for the last       *
*                      insert into a table containing an AUTO_INCREMENT *
*                      column                                           *
*                                                                       *
* Synopsis																*
*	#include <Inc/rdbi.h>												*
*	mysql_get_gen_id(table_name, id) 								    *
*	char *table_name;													*
*	int64  *id;														    *
*																		*
* Description															*
*																		*
* Parameters															*
*	table_name: input													*
*		Not used. MySql doesn't have this feature to specify the table  *
*																		*
*	id: output														    *
*		Autogenerated value after last insert.						    *
*																		*
* Function value														*
*	Returns an rdbi status code from Inc/rdbi.h 						*
*																		*
* Remarks																*
*																		*
************************************************************************/

#include "stdafx.h"

#include "est_cursor.h"
#include "sql.h"
#include "define.h"
#include "execute.h"
#include "fetch.h"
#include "fre_cursor.h"
#include "xlt_status.h"
#include "get_gen_id.h"

int mysql_get_gen_id(
    mysql_context_def  *context,
	char *table_name,   // not used
#ifdef _WIN32
	_int64  *id
#else
	int64_t  *id
#endif
	)
{
	char				    sql_buf[100];
	int 				    rows;
    int iid = 0;
	mysql_cursor_def	    *c = NULL;

    int    rdbi_status = RDBI_GENERIC_ERROR;

    // NOTE: mysql_insert_id( mysql ) doesn't work; Therefore run a query.

	/* establish cursor */
	if ( RDBI_SUCCESS != mysql_est_cursor(context, (char **)&c) )
        goto the_exit;

	sprintf(sql_buf, "select LAST_INSERT_ID()");

	if ( RDBI_SUCCESS != mysql_sql( context, (char *)c, sql_buf, FALSE, (char *)NULL,
								NULL, (char *) NULL) )
        goto the_exit;

	/* define output locations */
	if ( RDBI_SUCCESS != mysql_define( context, (char *)c, "1", RDBI_LONG, sizeof(long),
									(char *) &iid, (short *)NULL) )
        goto the_exit;

    /* execute the SQL statement */
    if ( RDBI_SUCCESS != mysql_execute( context, (char *)c, 1, 0, &rows) )
        goto the_exit;

	/* execute the SQL statement & fetch row */
	if ( RDBI_SUCCESS != mysql_fetch( context, (char *)c, 1, FALSE, FALSE, &rows) )
        goto the_exit;

    if (c != (mysql_cursor_def *)NULL)
        mysql_fre_cursor (context, (char **)&c);

    *id = iid;
    rdbi_status = RDBI_SUCCESS;

the_exit:
	return rdbi_status;
}
