// Copyright (c) 2023 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=94b9ddc326e4b71aefa8488594a3a6f481624254$
//

#include "libcef_dll/cpptoc/views/window_cpptoc.h"
#include "libcef_dll/cpptoc/image_cpptoc.h"
#include "libcef_dll/cpptoc/menu_model_cpptoc.h"
#include "libcef_dll/cpptoc/views/box_layout_cpptoc.h"
#include "libcef_dll/cpptoc/views/browser_view_cpptoc.h"
#include "libcef_dll/cpptoc/views/button_cpptoc.h"
#include "libcef_dll/cpptoc/views/display_cpptoc.h"
#include "libcef_dll/cpptoc/views/fill_layout_cpptoc.h"
#include "libcef_dll/cpptoc/views/layout_cpptoc.h"
#include "libcef_dll/cpptoc/views/overlay_controller_cpptoc.h"
#include "libcef_dll/cpptoc/views/panel_cpptoc.h"
#include "libcef_dll/cpptoc/views/scroll_view_cpptoc.h"
#include "libcef_dll/cpptoc/views/textfield_cpptoc.h"
#include "libcef_dll/cpptoc/views/view_cpptoc.h"
#include "libcef_dll/ctocpp/views/view_delegate_ctocpp.h"
#include "libcef_dll/ctocpp/views/window_delegate_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"

// GLOBAL FUNCTIONS - Body may be edited by hand.

CEF_EXPORT cef_window_t* cef_window_create_top_level(
    struct _cef_window_delegate_t* delegate) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: delegate

  // Execute
  CefRefPtr<CefWindow> _retval =
      CefWindow::CreateTopLevelWindow(CefWindowDelegateCToCpp::Wrap(delegate));

  // Return type: refptr_same
  return CefWindowCppToC::Wrap(_retval);
}

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

void CEF_CALLBACK window_show(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->Show();
}

void CEF_CALLBACK window_hide(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->Hide();
}

void CEF_CALLBACK window_center_window(struct _cef_window_t* self,
                                       const cef_size_t* size) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: size; type: simple_byref_const
  DCHECK(size);
  if (!size) {
    return;
  }

  // Translate param: size; type: simple_byref_const
  CefSize sizeVal = size ? *size : CefSize();

  // Execute
  CefWindowCppToC::Get(self)->CenterWindow(sizeVal);
}

void CEF_CALLBACK window_close(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->Close();
}

int CEF_CALLBACK window_is_closed(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefWindowCppToC::Get(self)->IsClosed();

  // Return type: bool
  return _retval;
}

void CEF_CALLBACK window_activate(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->Activate();
}

void CEF_CALLBACK window_deactivate(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->Deactivate();
}

int CEF_CALLBACK window_is_active(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefWindowCppToC::Get(self)->IsActive();

  // Return type: bool
  return _retval;
}

void CEF_CALLBACK window_bring_to_top(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->BringToTop();
}

void CEF_CALLBACK window_set_always_on_top(struct _cef_window_t* self,
                                           int on_top) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->SetAlwaysOnTop(on_top ? true : false);
}

int CEF_CALLBACK window_is_always_on_top(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefWindowCppToC::Get(self)->IsAlwaysOnTop();

  // Return type: bool
  return _retval;
}

void CEF_CALLBACK window_maximize(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->Maximize();
}

void CEF_CALLBACK window_minimize(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->Minimize();
}

void CEF_CALLBACK window_restore(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->Restore();
}

void CEF_CALLBACK window_set_fullscreen(struct _cef_window_t* self,
                                        int fullscreen) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->SetFullscreen(fullscreen ? true : false);
}

int CEF_CALLBACK window_is_maximized(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefWindowCppToC::Get(self)->IsMaximized();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_is_minimized(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefWindowCppToC::Get(self)->IsMinimized();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_is_fullscreen(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefWindowCppToC::Get(self)->IsFullscreen();

  // Return type: bool
  return _retval;
}

void CEF_CALLBACK window_set_title(struct _cef_window_t* self,
                                   const cef_string_t* title) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Unverified params: title

  // Execute
  CefWindowCppToC::Get(self)->SetTitle(CefString(title));
}

cef_string_userfree_t CEF_CALLBACK
window_get_title(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefWindowCppToC::Get(self)->GetTitle();

  // Return type: string
  return _retval.DetachToUserFree();
}

void CEF_CALLBACK window_set_window_icon(struct _cef_window_t* self,
                                         cef_image_t* image) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: image; type: refptr_same
  DCHECK(image);
  if (!image) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->SetWindowIcon(CefImageCppToC::Unwrap(image));
}

cef_image_t* CEF_CALLBACK window_get_window_icon(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefImage> _retval = CefWindowCppToC::Get(self)->GetWindowIcon();

  // Return type: refptr_same
  return CefImageCppToC::Wrap(_retval);
}

void CEF_CALLBACK window_set_window_app_icon(struct _cef_window_t* self,
                                             cef_image_t* image) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: image; type: refptr_same
  DCHECK(image);
  if (!image) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->SetWindowAppIcon(CefImageCppToC::Unwrap(image));
}

cef_image_t* CEF_CALLBACK
window_get_window_app_icon(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefImage> _retval = CefWindowCppToC::Get(self)->GetWindowAppIcon();

  // Return type: refptr_same
  return CefImageCppToC::Wrap(_retval);
}

cef_overlay_controller_t* CEF_CALLBACK
window_add_overlay_view(struct _cef_window_t* self,
                        cef_view_t* view,
                        cef_docking_mode_t docking_mode) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: view; type: refptr_same
  DCHECK(view);
  if (!view) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefOverlayController> _retval =
      CefWindowCppToC::Get(self)->AddOverlayView(CefViewCppToC::Unwrap(view),
                                                 docking_mode);

  // Return type: refptr_same
  return CefOverlayControllerCppToC::Wrap(_retval);
}

void CEF_CALLBACK window_show_menu(struct _cef_window_t* self,
                                   cef_menu_model_t* menu_model,
                                   const cef_point_t* screen_point,
                                   cef_menu_anchor_position_t anchor_position) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: menu_model; type: refptr_same
  DCHECK(menu_model);
  if (!menu_model) {
    return;
  }
  // Verify param: screen_point; type: simple_byref_const
  DCHECK(screen_point);
  if (!screen_point) {
    return;
  }

  // Translate param: screen_point; type: simple_byref_const
  CefPoint screen_pointVal = screen_point ? *screen_point : CefPoint();

  // Execute
  CefWindowCppToC::Get(self)->ShowMenu(CefMenuModelCppToC::Unwrap(menu_model),
                                       screen_pointVal, anchor_position);
}

void CEF_CALLBACK window_cancel_menu(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->CancelMenu();
}

cef_display_t* CEF_CALLBACK window_get_display(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefDisplay> _retval = CefWindowCppToC::Get(self)->GetDisplay();

  // Return type: refptr_same
  return CefDisplayCppToC::Wrap(_retval);
}

cef_rect_t CEF_CALLBACK
window_get_client_area_bounds_in_screen(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefRect();
  }

  // Execute
  cef_rect_t _retval =
      CefWindowCppToC::Get(self)->GetClientAreaBoundsInScreen();

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK
window_set_draggable_regions(struct _cef_window_t* self,
                             size_t regionsCount,
                             cef_draggable_region_t const* regions) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Unverified params: regions

  // Translate param: regions; type: simple_vec_byref_const
  std::vector<CefDraggableRegion> regionsList;
  if (regionsCount > 0) {
    for (size_t i = 0; i < regionsCount; ++i) {
      CefDraggableRegion regionsVal = regions[i];
      regionsList.push_back(regionsVal);
    }
  }

  // Execute
  CefWindowCppToC::Get(self)->SetDraggableRegions(regionsList);
}

cef_window_handle_t CEF_CALLBACK
window_get_window_handle(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return kNullWindowHandle;
  }

  // Execute
  cef_window_handle_t _retval = CefWindowCppToC::Get(self)->GetWindowHandle();

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK window_send_key_press(struct _cef_window_t* self,
                                        int key_code,
                                        uint32 event_flags) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->SendKeyPress(key_code, event_flags);
}

void CEF_CALLBACK window_send_mouse_move(struct _cef_window_t* self,
                                         int screen_x,
                                         int screen_y) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->SendMouseMove(screen_x, screen_y);
}

void CEF_CALLBACK window_send_mouse_events(struct _cef_window_t* self,
                                           cef_mouse_button_type_t button,
                                           int mouse_down,
                                           int mouse_up) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->SendMouseEvents(button, mouse_down ? true : false,
                                              mouse_up ? true : false);
}

void CEF_CALLBACK window_set_accelerator(struct _cef_window_t* self,
                                         int command_id,
                                         int key_code,
                                         int shift_pressed,
                                         int ctrl_pressed,
                                         int alt_pressed) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->SetAccelerator(
      command_id, key_code, shift_pressed ? true : false,
      ctrl_pressed ? true : false, alt_pressed ? true : false);
}

void CEF_CALLBACK window_remove_accelerator(struct _cef_window_t* self,
                                            int command_id) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->RemoveAccelerator(command_id);
}

void CEF_CALLBACK window_remove_all_accelerators(struct _cef_window_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(self)->RemoveAllAccelerators();
}

struct _cef_window_t* CEF_CALLBACK window_as_window(struct _cef_panel_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefWindow> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->AsWindow();

  // Return type: refptr_same
  return CefWindowCppToC::Wrap(_retval);
}

cef_fill_layout_t* CEF_CALLBACK
window_set_to_fill_layout(struct _cef_panel_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefFillLayout> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->SetToFillLayout();

  // Return type: refptr_same
  return CefFillLayoutCppToC::Wrap(_retval);
}

cef_box_layout_t* CEF_CALLBACK
window_set_to_box_layout(struct _cef_panel_t* self,
                         const cef_box_layout_settings_t* settings) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: settings; type: simple_byref_const
  DCHECK(settings);
  if (!settings) {
    return NULL;
  }

  // Translate param: settings; type: simple_byref_const
  CefBoxLayoutSettings settingsVal =
      settings ? *settings : CefBoxLayoutSettings();

  // Execute
  CefRefPtr<CefBoxLayout> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->SetToBoxLayout(settingsVal);

  // Return type: refptr_same
  return CefBoxLayoutCppToC::Wrap(_retval);
}

cef_layout_t* CEF_CALLBACK window_get_layout(struct _cef_panel_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefLayout> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->GetLayout();

  // Return type: refptr_same
  return CefLayoutCppToC::Wrap(_retval);
}

void CEF_CALLBACK window_layout(struct _cef_panel_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->Layout();
}

void CEF_CALLBACK window_add_child_view(struct _cef_panel_t* self,
                                        cef_view_t* view) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_same
  DCHECK(view);
  if (!view) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->AddChildView(CefViewCppToC::Unwrap(view));
}

void CEF_CALLBACK window_add_child_view_at(struct _cef_panel_t* self,
                                           cef_view_t* view,
                                           int index) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_same
  DCHECK(view);
  if (!view) {
    return;
  }
  // Verify param: index; type: simple_byval
  DCHECK_GE(index, 0);
  if (index < 0) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->AddChildViewAt(CefViewCppToC::Unwrap(view), index);
}

void CEF_CALLBACK window_reorder_child_view(struct _cef_panel_t* self,
                                            cef_view_t* view,
                                            int index) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_same
  DCHECK(view);
  if (!view) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->ReorderChildView(CefViewCppToC::Unwrap(view), index);
}

void CEF_CALLBACK window_remove_child_view(struct _cef_panel_t* self,
                                           cef_view_t* view) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_same
  DCHECK(view);
  if (!view) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->RemoveChildView(CefViewCppToC::Unwrap(view));
}

void CEF_CALLBACK window_remove_all_child_views(struct _cef_panel_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->RemoveAllChildViews();
}

size_t CEF_CALLBACK window_get_child_view_count(struct _cef_panel_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  size_t _retval = CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
                       ->GetChildViewCount();

  // Return type: simple
  return _retval;
}

cef_view_t* CEF_CALLBACK window_get_child_view_at(struct _cef_panel_t* self,
                                                  int index) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: index; type: simple_byval
  DCHECK_GE(index, 0);
  if (index < 0) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefView> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetChildViewAt(index);

  // Return type: refptr_same
  return CefViewCppToC::Wrap(_retval);
}

cef_browser_view_t* CEF_CALLBACK
window_as_browser_view(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefBrowserView> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->AsBrowserView();

  // Return type: refptr_same
  return CefBrowserViewCppToC::Wrap(_retval);
}

cef_button_t* CEF_CALLBACK window_as_button(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefButton> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->AsButton();

  // Return type: refptr_same
  return CefButtonCppToC::Wrap(_retval);
}

cef_panel_t* CEF_CALLBACK window_as_panel(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefPanel> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->AsPanel();

  // Return type: refptr_same
  return CefPanelCppToC::Wrap(_retval);
}

cef_scroll_view_t* CEF_CALLBACK
window_as_scroll_view(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefScrollView> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->AsScrollView();

  // Return type: refptr_same
  return CefScrollViewCppToC::Wrap(_retval);
}

cef_textfield_t* CEF_CALLBACK window_as_textfield(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefTextfield> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->AsTextfield();

  // Return type: refptr_same
  return CefTextfieldCppToC::Wrap(_retval);
}

cef_string_userfree_t CEF_CALLBACK
window_get_type_string(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetTypeString();

  // Return type: string
  return _retval.DetachToUserFree();
}

cef_string_userfree_t CEF_CALLBACK window_to_string(struct _cef_view_t* self,
                                                    int include_children) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->ToString(include_children ? true : false);

  // Return type: string
  return _retval.DetachToUserFree();
}

int CEF_CALLBACK window_is_valid(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->IsValid();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_is_attached(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->IsAttached();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_is_same(struct _cef_view_t* self, cef_view_t* that) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: that; type: refptr_same
  DCHECK(that);
  if (!that) {
    return 0;
  }

  // Execute
  bool _retval = CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
                     ->IsSame(CefViewCppToC::Unwrap(that));

  // Return type: bool
  return _retval;
}

cef_view_delegate_t* CEF_CALLBACK
window_get_delegate(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefViewDelegate> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetDelegate();

  // Return type: refptr_diff
  return CefViewDelegateCToCpp::Unwrap(_retval);
}

struct _cef_window_t* CEF_CALLBACK window_get_window(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefWindow> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->GetWindow();

  // Return type: refptr_same
  return CefWindowCppToC::Wrap(_retval);
}

int CEF_CALLBACK window_get_id(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->GetID();

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK window_set_id(struct _cef_view_t* self, int id) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->SetID(id);
}

int CEF_CALLBACK window_get_group_id(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->GetGroupID();

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK window_set_group_id(struct _cef_view_t* self, int group_id) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->SetGroupID(group_id);
}

cef_view_t* CEF_CALLBACK window_get_parent_view(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefView> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetParentView();

  // Return type: refptr_same
  return CefViewCppToC::Wrap(_retval);
}

cef_view_t* CEF_CALLBACK window_get_view_for_id(struct _cef_view_t* self,
                                                int id) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefView> _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetViewForID(id);

  // Return type: refptr_same
  return CefViewCppToC::Wrap(_retval);
}

void CEF_CALLBACK window_set_bounds(struct _cef_view_t* self,
                                    const cef_rect_t* bounds) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: bounds; type: simple_byref_const
  DCHECK(bounds);
  if (!bounds) {
    return;
  }

  // Translate param: bounds; type: simple_byref_const
  CefRect boundsVal = bounds ? *bounds : CefRect();

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->SetBounds(boundsVal);
}

cef_rect_t CEF_CALLBACK window_get_bounds(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefRect();
  }

  // Execute
  cef_rect_t _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->GetBounds();

  // Return type: simple
  return _retval;
}

cef_rect_t CEF_CALLBACK window_get_bounds_in_screen(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefRect();
  }

  // Execute
  cef_rect_t _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetBoundsInScreen();

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK window_set_size(struct _cef_view_t* self,
                                  const cef_size_t* size) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: size; type: simple_byref_const
  DCHECK(size);
  if (!size) {
    return;
  }

  // Translate param: size; type: simple_byref_const
  CefSize sizeVal = size ? *size : CefSize();

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->SetSize(sizeVal);
}

cef_size_t CEF_CALLBACK window_get_size(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefSize();
  }

  // Execute
  cef_size_t _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->GetSize();

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK window_set_position(struct _cef_view_t* self,
                                      const cef_point_t* position) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: position; type: simple_byref_const
  DCHECK(position);
  if (!position) {
    return;
  }

  // Translate param: position; type: simple_byref_const
  CefPoint positionVal = position ? *position : CefPoint();

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->SetPosition(positionVal);
}

cef_point_t CEF_CALLBACK window_get_position(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefPoint();
  }

  // Execute
  cef_point_t _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetPosition();

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK window_set_insets(struct _cef_view_t* self,
                                    const cef_insets_t* insets) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: insets; type: simple_byref_const
  DCHECK(insets);
  if (!insets) {
    return;
  }

  // Translate param: insets; type: simple_byref_const
  CefInsets insetsVal = insets ? *insets : CefInsets();

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->SetInsets(insetsVal);
}

cef_insets_t CEF_CALLBACK window_get_insets(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefInsets();
  }

  // Execute
  cef_insets_t _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->GetInsets();

  // Return type: simple
  return _retval;
}

cef_size_t CEF_CALLBACK window_get_preferred_size(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefSize();
  }

  // Execute
  cef_size_t _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetPreferredSize();

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK window_size_to_preferred_size(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->SizeToPreferredSize();
}

cef_size_t CEF_CALLBACK window_get_minimum_size(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefSize();
  }

  // Execute
  cef_size_t _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetMinimumSize();

  // Return type: simple
  return _retval;
}

cef_size_t CEF_CALLBACK window_get_maximum_size(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefSize();
  }

  // Execute
  cef_size_t _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetMaximumSize();

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK window_get_height_for_width(struct _cef_view_t* self,
                                             int width) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int _retval = CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
                    ->GetHeightForWidth(width);

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK window_invalidate_layout(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->InvalidateLayout();
}

void CEF_CALLBACK window_set_visible(struct _cef_view_t* self, int visible) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->SetVisible(visible ? true : false);
}

int CEF_CALLBACK window_is_visible(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->IsVisible();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_is_drawn(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->IsDrawn();

  // Return type: bool
  return _retval;
}

void CEF_CALLBACK window_set_enabled(struct _cef_view_t* self, int enabled) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->SetEnabled(enabled ? true : false);
}

int CEF_CALLBACK window_is_enabled(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->IsEnabled();

  // Return type: bool
  return _retval;
}

void CEF_CALLBACK window_set_focusable(struct _cef_view_t* self,
                                       int focusable) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->SetFocusable(focusable ? true : false);
}

int CEF_CALLBACK window_is_focusable(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
                     ->IsFocusable();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_is_accessibility_focusable(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
                     ->IsAccessibilityFocusable();

  // Return type: bool
  return _retval;
}

void CEF_CALLBACK window_request_focus(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))->RequestFocus();
}

void CEF_CALLBACK window_set_background_color(struct _cef_view_t* self,
                                              cef_color_t color) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
      ->SetBackgroundColor(color);
}

cef_color_t CEF_CALLBACK window_get_background_color(struct _cef_view_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  cef_color_t _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->GetBackgroundColor();

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK window_convert_point_to_screen(struct _cef_view_t* self,
                                                cef_point_t* point) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: point; type: simple_byref
  DCHECK(point);
  if (!point) {
    return 0;
  }

  // Translate param: point; type: simple_byref
  CefPoint pointVal = point ? *point : CefPoint();

  // Execute
  bool _retval = CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
                     ->ConvertPointToScreen(pointVal);

  // Restore param: point; type: simple_byref
  if (point) {
    *point = pointVal;
  }

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_convert_point_from_screen(struct _cef_view_t* self,
                                                  cef_point_t* point) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: point; type: simple_byref
  DCHECK(point);
  if (!point) {
    return 0;
  }

  // Translate param: point; type: simple_byref
  CefPoint pointVal = point ? *point : CefPoint();

  // Execute
  bool _retval = CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
                     ->ConvertPointFromScreen(pointVal);

  // Restore param: point; type: simple_byref
  if (point) {
    *point = pointVal;
  }

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_convert_point_to_window(struct _cef_view_t* self,
                                                cef_point_t* point) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: point; type: simple_byref
  DCHECK(point);
  if (!point) {
    return 0;
  }

  // Translate param: point; type: simple_byref
  CefPoint pointVal = point ? *point : CefPoint();

  // Execute
  bool _retval = CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
                     ->ConvertPointToWindow(pointVal);

  // Restore param: point; type: simple_byref
  if (point) {
    *point = pointVal;
  }

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_convert_point_from_window(struct _cef_view_t* self,
                                                  cef_point_t* point) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: point; type: simple_byref
  DCHECK(point);
  if (!point) {
    return 0;
  }

  // Translate param: point; type: simple_byref
  CefPoint pointVal = point ? *point : CefPoint();

  // Execute
  bool _retval = CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
                     ->ConvertPointFromWindow(pointVal);

  // Restore param: point; type: simple_byref
  if (point) {
    *point = pointVal;
  }

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_convert_point_to_view(struct _cef_view_t* self,
                                              cef_view_t* view,
                                              cef_point_t* point) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: view; type: refptr_same
  DCHECK(view);
  if (!view) {
    return 0;
  }
  // Verify param: point; type: simple_byref
  DCHECK(point);
  if (!point) {
    return 0;
  }

  // Translate param: point; type: simple_byref
  CefPoint pointVal = point ? *point : CefPoint();

  // Execute
  bool _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->ConvertPointToView(CefViewCppToC::Unwrap(view), pointVal);

  // Restore param: point; type: simple_byref
  if (point) {
    *point = pointVal;
  }

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK window_convert_point_from_view(struct _cef_view_t* self,
                                                cef_view_t* view,
                                                cef_point_t* point) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: view; type: refptr_same
  DCHECK(view);
  if (!view) {
    return 0;
  }
  // Verify param: point; type: simple_byref
  DCHECK(point);
  if (!point) {
    return 0;
  }

  // Translate param: point; type: simple_byref
  CefPoint pointVal = point ? *point : CefPoint();

  // Execute
  bool _retval =
      CefWindowCppToC::Get(reinterpret_cast<cef_window_t*>(self))
          ->ConvertPointFromView(CefViewCppToC::Unwrap(view), pointVal);

  // Restore param: point; type: simple_byref
  if (point) {
    *point = pointVal;
  }

  // Return type: bool
  return _retval;
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefWindowCppToC::CefWindowCppToC() {
  GetStruct()->show = window_show;
  GetStruct()->hide = window_hide;
  GetStruct()->center_window = window_center_window;
  GetStruct()->close = window_close;
  GetStruct()->is_closed = window_is_closed;
  GetStruct()->activate = window_activate;
  GetStruct()->deactivate = window_deactivate;
  GetStruct()->is_active = window_is_active;
  GetStruct()->bring_to_top = window_bring_to_top;
  GetStruct()->set_always_on_top = window_set_always_on_top;
  GetStruct()->is_always_on_top = window_is_always_on_top;
  GetStruct()->maximize = window_maximize;
  GetStruct()->minimize = window_minimize;
  GetStruct()->restore = window_restore;
  GetStruct()->set_fullscreen = window_set_fullscreen;
  GetStruct()->is_maximized = window_is_maximized;
  GetStruct()->is_minimized = window_is_minimized;
  GetStruct()->is_fullscreen = window_is_fullscreen;
  GetStruct()->set_title = window_set_title;
  GetStruct()->get_title = window_get_title;
  GetStruct()->set_window_icon = window_set_window_icon;
  GetStruct()->get_window_icon = window_get_window_icon;
  GetStruct()->set_window_app_icon = window_set_window_app_icon;
  GetStruct()->get_window_app_icon = window_get_window_app_icon;
  GetStruct()->add_overlay_view = window_add_overlay_view;
  GetStruct()->show_menu = window_show_menu;
  GetStruct()->cancel_menu = window_cancel_menu;
  GetStruct()->get_display = window_get_display;
  GetStruct()->get_client_area_bounds_in_screen =
      window_get_client_area_bounds_in_screen;
  GetStruct()->set_draggable_regions = window_set_draggable_regions;
  GetStruct()->get_window_handle = window_get_window_handle;
  GetStruct()->send_key_press = window_send_key_press;
  GetStruct()->send_mouse_move = window_send_mouse_move;
  GetStruct()->send_mouse_events = window_send_mouse_events;
  GetStruct()->set_accelerator = window_set_accelerator;
  GetStruct()->remove_accelerator = window_remove_accelerator;
  GetStruct()->remove_all_accelerators = window_remove_all_accelerators;
  GetStruct()->base.as_window = window_as_window;
  GetStruct()->base.set_to_fill_layout = window_set_to_fill_layout;
  GetStruct()->base.set_to_box_layout = window_set_to_box_layout;
  GetStruct()->base.get_layout = window_get_layout;
  GetStruct()->base.layout = window_layout;
  GetStruct()->base.add_child_view = window_add_child_view;
  GetStruct()->base.add_child_view_at = window_add_child_view_at;
  GetStruct()->base.reorder_child_view = window_reorder_child_view;
  GetStruct()->base.remove_child_view = window_remove_child_view;
  GetStruct()->base.remove_all_child_views = window_remove_all_child_views;
  GetStruct()->base.get_child_view_count = window_get_child_view_count;
  GetStruct()->base.get_child_view_at = window_get_child_view_at;
  GetStruct()->base.base.as_browser_view = window_as_browser_view;
  GetStruct()->base.base.as_button = window_as_button;
  GetStruct()->base.base.as_panel = window_as_panel;
  GetStruct()->base.base.as_scroll_view = window_as_scroll_view;
  GetStruct()->base.base.as_textfield = window_as_textfield;
  GetStruct()->base.base.get_type_string = window_get_type_string;
  GetStruct()->base.base.to_string = window_to_string;
  GetStruct()->base.base.is_valid = window_is_valid;
  GetStruct()->base.base.is_attached = window_is_attached;
  GetStruct()->base.base.is_same = window_is_same;
  GetStruct()->base.base.get_delegate = window_get_delegate;
  GetStruct()->base.base.get_window = window_get_window;
  GetStruct()->base.base.get_id = window_get_id;
  GetStruct()->base.base.set_id = window_set_id;
  GetStruct()->base.base.get_group_id = window_get_group_id;
  GetStruct()->base.base.set_group_id = window_set_group_id;
  GetStruct()->base.base.get_parent_view = window_get_parent_view;
  GetStruct()->base.base.get_view_for_id = window_get_view_for_id;
  GetStruct()->base.base.set_bounds = window_set_bounds;
  GetStruct()->base.base.get_bounds = window_get_bounds;
  GetStruct()->base.base.get_bounds_in_screen = window_get_bounds_in_screen;
  GetStruct()->base.base.set_size = window_set_size;
  GetStruct()->base.base.get_size = window_get_size;
  GetStruct()->base.base.set_position = window_set_position;
  GetStruct()->base.base.get_position = window_get_position;
  GetStruct()->base.base.set_insets = window_set_insets;
  GetStruct()->base.base.get_insets = window_get_insets;
  GetStruct()->base.base.get_preferred_size = window_get_preferred_size;
  GetStruct()->base.base.size_to_preferred_size = window_size_to_preferred_size;
  GetStruct()->base.base.get_minimum_size = window_get_minimum_size;
  GetStruct()->base.base.get_maximum_size = window_get_maximum_size;
  GetStruct()->base.base.get_height_for_width = window_get_height_for_width;
  GetStruct()->base.base.invalidate_layout = window_invalidate_layout;
  GetStruct()->base.base.set_visible = window_set_visible;
  GetStruct()->base.base.is_visible = window_is_visible;
  GetStruct()->base.base.is_drawn = window_is_drawn;
  GetStruct()->base.base.set_enabled = window_set_enabled;
  GetStruct()->base.base.is_enabled = window_is_enabled;
  GetStruct()->base.base.set_focusable = window_set_focusable;
  GetStruct()->base.base.is_focusable = window_is_focusable;
  GetStruct()->base.base.is_accessibility_focusable =
      window_is_accessibility_focusable;
  GetStruct()->base.base.request_focus = window_request_focus;
  GetStruct()->base.base.set_background_color = window_set_background_color;
  GetStruct()->base.base.get_background_color = window_get_background_color;
  GetStruct()->base.base.convert_point_to_screen =
      window_convert_point_to_screen;
  GetStruct()->base.base.convert_point_from_screen =
      window_convert_point_from_screen;
  GetStruct()->base.base.convert_point_to_window =
      window_convert_point_to_window;
  GetStruct()->base.base.convert_point_from_window =
      window_convert_point_from_window;
  GetStruct()->base.base.convert_point_to_view = window_convert_point_to_view;
  GetStruct()->base.base.convert_point_from_view =
      window_convert_point_from_view;
}

// DESTRUCTOR - Do not edit by hand.

CefWindowCppToC::~CefWindowCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefWindow>
CefCppToCRefCounted<CefWindowCppToC, CefWindow, cef_window_t>::UnwrapDerived(
    CefWrapperType type,
    cef_window_t* s) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefWindowCppToC, CefWindow, cef_window_t>::
    kWrapperType = WT_WINDOW;
