// Copyright (c) 2023 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=9e43a166c77c493dfdc85dd795f1fcf1010b4785$
//

#include "libcef_dll/cpptoc/stream_writer_cpptoc.h"
#include "libcef_dll/ctocpp/write_handler_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"

// GLOBAL FUNCTIONS - Body may be edited by hand.

CEF_EXPORT cef_stream_writer_t* cef_stream_writer_create_for_file(
    const cef_string_t* fileName) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: fileName; type: string_byref_const
  DCHECK(fileName);
  if (!fileName) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefStreamWriter> _retval =
      CefStreamWriter::CreateForFile(CefString(fileName));

  // Return type: refptr_same
  return CefStreamWriterCppToC::Wrap(_retval);
}

CEF_EXPORT cef_stream_writer_t* cef_stream_writer_create_for_handler(
    cef_write_handler_t* handler) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: handler; type: refptr_diff
  DCHECK(handler);
  if (!handler) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefStreamWriter> _retval =
      CefStreamWriter::CreateForHandler(CefWriteHandlerCToCpp::Wrap(handler));

  // Return type: refptr_same
  return CefStreamWriterCppToC::Wrap(_retval);
}

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

size_t CEF_CALLBACK stream_writer_write(struct _cef_stream_writer_t* self,
                                        const void* ptr,
                                        size_t size,
                                        size_t n) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: ptr; type: simple_byaddr
  DCHECK(ptr);
  if (!ptr) {
    return 0;
  }

  // Execute
  size_t _retval = CefStreamWriterCppToC::Get(self)->Write(ptr, size, n);

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK stream_writer_seek(struct _cef_stream_writer_t* self,
                                    int64 offset,
                                    int whence) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int _retval = CefStreamWriterCppToC::Get(self)->Seek(offset, whence);

  // Return type: simple
  return _retval;
}

int64 CEF_CALLBACK stream_writer_tell(struct _cef_stream_writer_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int64 _retval = CefStreamWriterCppToC::Get(self)->Tell();

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK stream_writer_flush(struct _cef_stream_writer_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int _retval = CefStreamWriterCppToC::Get(self)->Flush();

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK stream_writer_may_block(struct _cef_stream_writer_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefStreamWriterCppToC::Get(self)->MayBlock();

  // Return type: bool
  return _retval;
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefStreamWriterCppToC::CefStreamWriterCppToC() {
  GetStruct()->write = stream_writer_write;
  GetStruct()->seek = stream_writer_seek;
  GetStruct()->tell = stream_writer_tell;
  GetStruct()->flush = stream_writer_flush;
  GetStruct()->may_block = stream_writer_may_block;
}

// DESTRUCTOR - Do not edit by hand.

CefStreamWriterCppToC::~CefStreamWriterCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefStreamWriter> CefCppToCRefCounted<
    CefStreamWriterCppToC,
    CefStreamWriter,
    cef_stream_writer_t>::UnwrapDerived(CefWrapperType type,
                                        cef_stream_writer_t* s) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefStreamWriterCppToC,
                                   CefStreamWriter,
                                   cef_stream_writer_t>::kWrapperType =
    WT_STREAM_WRITER;
