// Copyright (c) 2023 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=28f41d6cd0959174263b1cf5d1da37b4fe4c463b$
//

#include "libcef_dll/cpptoc/media_source_cpptoc.h"
#include "libcef_dll/shutdown_checker.h"

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

cef_string_userfree_t CEF_CALLBACK
media_source_get_id(struct _cef_media_source_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefMediaSourceCppToC::Get(self)->GetId();

  // Return type: string
  return _retval.DetachToUserFree();
}

int CEF_CALLBACK media_source_is_cast_source(struct _cef_media_source_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefMediaSourceCppToC::Get(self)->IsCastSource();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK media_source_is_dial_source(struct _cef_media_source_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefMediaSourceCppToC::Get(self)->IsDialSource();

  // Return type: bool
  return _retval;
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefMediaSourceCppToC::CefMediaSourceCppToC() {
  GetStruct()->get_id = media_source_get_id;
  GetStruct()->is_cast_source = media_source_is_cast_source;
  GetStruct()->is_dial_source = media_source_is_dial_source;
}

// DESTRUCTOR - Do not edit by hand.

CefMediaSourceCppToC::~CefMediaSourceCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefMediaSource>
CefCppToCRefCounted<CefMediaSourceCppToC, CefMediaSource, cef_media_source_t>::
    UnwrapDerived(CefWrapperType type, cef_media_source_t* s) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefMediaSourceCppToC,
                                   CefMediaSource,
                                   cef_media_source_t>::kWrapperType =
    WT_MEDIA_SOURCE;
