/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "stdafx.h"
#include <Sm/Ph/ClassPropertyReader.h>
#include <Sm/Ph/DbObject.h>

FdoSmPhClassPropertyReader::FdoSmPhClassPropertyReader( 
	FdoStringP schemaName, 
	FdoStringP className, 
	FdoSmPhPropertyReaderP propReader,
	FdoSmPhSADReaderP SADReader
) :
	FdoSmPhGroupReader( className, FdoSmPhReaderP(FDO_SAFE_ADDREF(propReader.p)) ),
	mSchemaName(schemaName),
	mClassName(className),
	mPropReader(propReader),
	mpSADReader(SADReader)
{
}

FdoSmPhClassPropertyReader::~FdoSmPhClassPropertyReader(void)
{
}

FdoStringP FdoSmPhClassPropertyReader::GetGroupName()
{
	return( mPropReader->GetFeatureClassName() );
}

FdoStringP FdoSmPhClassPropertyReader::GetName()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetName());
}

FdoStringP FdoSmPhClassPropertyReader::GetColumnName()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetColumnName());
}

FdoStringP FdoSmPhClassPropertyReader::GetColumnType()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetColumnType());
}

bool FdoSmPhClassPropertyReader::GetIsFixedColumn()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetIsFixedColumn());
}

bool FdoSmPhClassPropertyReader::GetIsColumnCreator()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetIsColumnCreator());
}

FdoStringP FdoSmPhClassPropertyReader::GetDescription()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetDescription());
}

FdoStringP FdoSmPhClassPropertyReader::GetFeatureClassName()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetFeatureClassName());
}

FdoStringP FdoSmPhClassPropertyReader::GetDataType()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetDataType());
}
FdoStringP FdoSmPhClassPropertyReader::GetGeometryType()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetGeometryType());
}

int FdoSmPhClassPropertyReader::GetIdPosition()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetIdPosition());
}

bool FdoSmPhClassPropertyReader::GetIsNullable()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetIsNullable());
}

bool FdoSmPhClassPropertyReader::GetIsReadOnly()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetIsReadOnly());
}

bool FdoSmPhClassPropertyReader::GetIsFeatId()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetIsFeatId());
}

bool FdoSmPhClassPropertyReader::GetIsSystem()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetIsSystem());
}

int FdoSmPhClassPropertyReader::GetLength()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetLength());
}

int FdoSmPhClassPropertyReader::GetScale()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetScale());
}

FdoStringP FdoSmPhClassPropertyReader::GetTableName()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetTableName());
}

FdoStringP FdoSmPhClassPropertyReader::GetRootObjectName()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetRootObjectName());
}

FdoPtr<FdoDataValue> FdoSmPhClassPropertyReader::GetDefaultValue()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetDefaultValue());
}

bool FdoSmPhClassPropertyReader::GetHasElevation()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetHasElevation());
}

bool FdoSmPhClassPropertyReader::GetHasMeasure()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetHasMeasure());
}

bool FdoSmPhClassPropertyReader::GetIsAutoGenerated()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetIsAutoGenerated());
}

FdoStringP FdoSmPhClassPropertyReader::GetSequenceName()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetSequenceName());
}

bool FdoSmPhClassPropertyReader::GetIsRevisionNumber()
{
	// Make sure there is a current row.
	CheckGet();

    return(mPropReader->GetIsRevisionNumber());
}
/*
const FdoSmPhTable* FdoSmPhClassPropertyReader::GetTable()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetTable());
}
*/
/* TODO

FdoSmPhDependencyReaderP FdoSmPhClassPropertyReader::GetDependencyReader()
{
	// Make sure there is a current row.
	CheckGet();

	return(mPropReader->GetDependencyReader());
}
*/
FdoSmPhClassPropertySADReaderP FdoSmPhClassPropertyReader::GetSADReader()
{
	// Note that the class property SAD reader only works properly if the 
	// SAD reader retrieves rows by schemaName, className and propertyName.
	return new FdoSmPhClassPropertySADReader(mSchemaName, mClassName, GetName(), mpSADReader );
}



