#ifndef FDOSMPHCLASSWRITER_H
#define FDOSMPHCLASSWRITER_H		1
/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */

#ifdef _WIN32
#pragma once
#endif

#include <Sm/Ph/CommandWriter.h>
#include <Sm/Ph/SOWriter.h>
#include <Sm/Ph/ClassSOWriter.h>

// This class writes association definitions 
// to the f_classdefinition table.
class FdoSmPhClassWriter : public FdoSmPhWriter
{
public:

    /// Create a class definition writer.
	//
    /// Parameters:
    /// 	mgr: holds the connection for the datastore to query.
	FdoSmPhClassWriter(FdoSmPhMgrP mgr);

	~FdoSmPhClassWriter(void);
    
    /// Various field value getters

    /// Class name
	FdoStringP GetName();

    /// Schema name
	FdoStringP GetSchemaName();

    /// Base Class name
	FdoStringP GetBaseName();

    /// Class description
	FdoStringP GetDescription();

    /// Class table name (actually a view when table is foreign).
	FdoStringP GetTableName();

    /// Root table name (the table name when table is foreign).
    /// L"" when table not foreign.
	FdoStringP GetRootTableName();

    /// Table mapping type if explicitly set by Schema Overrides.
	FdoStringP GetTableMapping();

    /// Get the table storage (corresponds to tablespace in Oracle, table filegroup in SQL Server, etc)
	FdoStringP GetTableStorage();

    /// Class Type ( Class, Feature, Tin, etc. )
	FdoStringP GetClassType();

    /// true if the class is abstract
	bool GetIsAbstract();

    /// true if class table has fixed name specified through 
    /// schema overrides
    bool GetIsFixedTable();

    /// true if this class owns the class table (table was created when class was created)
    /// false if this class attached itself to pre-existing table when it was created. 
    bool GetIsTableCreator();

    /// Database instance for class table
    /// if L"" then class table is in current Oracle instance.
	FdoStringP GetDatabase();

    /// Oracle schema that owns the class table
    /// if L"" then class table is in current Oracle schema.
	FdoStringP GetOwner();

    /// Main geometry for feature class
    /// if L"" then there is no main geometry
	FdoStringP GetGeometryProperty();

    /// class id
    FdoInt64 GetId();

    /// Schema Option
    FdoStringP GetOption( FdoStringP optionName );

    /// Corresponding setter functions. There's none for classid 
    /// since it is autogenerated when a new class is written.

	void SetName( FdoStringP sValue );

    void SetSchemaName( FdoStringP sValue );

	void SetBaseName( FdoStringP sValue );

	void  SetDescription( FdoStringP sValue );

	void SetTableName( FdoStringP sValue );

	void SetRootTableName( FdoStringP sValue );

	void SetTableMapping(FdoStringP sValue);

	void SetTableStorage(FdoStringP sValue);

	void SetClassType( FdoStringP sValue );

	void SetIsAbstract( bool bValue );

	void SetDatabase( FdoStringP sValue );

    void SetOwner( FdoStringP sValue );

    void SetGeometryProperty( FdoStringP sValue );

	void SetIsFixedTable( bool bValue );

	void SetIsTableCreator( bool bValue );

    void SetOption( FdoStringP optionName, FdoStringP optionValue );

    /// Add the current row as a new class definition
	virtual void Add();

    /// Modify a class definition using the current field values.
    //
    /// Parameters
    ///      classId: primary key of the class to modify
    virtual void Modify( FdoString* schemaName, FdoString* className, FdoInt64 classId );

    /// Delete a class definition using the current field values.
    //
    /// Parameters
    ///      classId: primary key of the class to delete
    virtual void Delete( FdoString* schemaName, FdoString* className, FdoInt64 classId );

    /// Get a field list for reading from or writing to 
    /// f_classdefinition.
	//
    /// Parameters:
    /// 	physicalSchema: holds the connection for the datastore to query.
    static FdoSmPhRowP MakeRow( FdoSmPhMgrP mgr );

    /// Get a field list for reading from the class type (f_classtype)
    /// lookup table.
	//
    /// Parameters:
    /// 	physicalSchema: holds the connection for the datastore to query.
    static FdoSmPhRowP MakeClassTypeRow( FdoSmPhMgrP mgr );

protected:
    /// Unused constructor needed only to build on Linux
    FdoSmPhClassWriter() {}

    FdoSmPhWriterP MakeWriter( FdoSmPhMgrP mgr );
    
    void SetId( FdoInt64 lValue);

private:
	bool mbSchemaOptionsTableDefined;
	FdoSmPhClassSOWriterP mpClassSOWriter;
};

typedef FdoPtr<FdoSmPhClassWriter> FdoSmPhClassWriterP;

#endif


