#include "StdAfx.h"

#include "c_KgOraUtil.h"
#include "ut_KgOraSdeSchema.h"
// Provider specific headers
#include <KingOracle/FdoKgOraOverrides.h>
#include "KgOraProvider.h"
#include "../Message/inc/KgOraMessage.h"

#include "c_KgOraSridDesc.h"
#include "c_SdeGeom2AGF.h"


#include <c_KgOraSridDesc.h>
#include <c_KgOraConnectionCapabilities.h>
#include <c_KgOraCommandCapabilities.h>
#include <c_KgOraExpressionCapabilities.h>
#include <c_KgOraFilterCapabilities.h>
#include <c_KgOraSchemaCapabilities.h>
#include <c_KgOraRasterCapabilities.h>
#include <c_KgOraTopologyCapabilities.h>
#include <c_KgOraGeometryCapabilities.h>
#include <c_KgOraConnection.h>
#include <c_KgOraConnectionInfo.h>
#include <c_KgOraFdoFeatureCommand.h>
#include <c_KgOraSchemaDesc.h>
#include <c_KgOraDescribeSchemaCommand.h>



CPPUNIT_TEST_SUITE_REGISTRATION(ut_KgOraSdeSchema);



ut_KgOraSdeSchema::ut_KgOraSdeSchema(void)
{
}

ut_KgOraSdeSchema::~ut_KgOraSdeSchema(void)
{
}




void ut_KgOraSdeSchema::DescribeSdeSchema()
{
try
{
  FdoPtr<FdoIConnection> conn = c_KgOraUtil::OpenUnitTestConn_10_2_SDE();
  
  c_KgOraConnection* kingora_conn = (c_KgOraConnection*)conn.p;
  kingora_conn->ClearCachedSchemaDesc();
  
  FdoPtr<FdoIDescribeSchema> comm = (FdoIDescribeSchema*)conn->CreateCommand(FdoCommandType_DescribeSchema);

  
  FdoPtr<FdoFeatureSchemaCollection> schemas = comm->Execute();
  
  CPPUNIT_ASSERT_MESSAGE( "FdoIDescribeSchema:Execute returns NULL schema collection" , schemas );
    

  long count_schema =schemas->GetCount();
  
  FdoPtr<FdoFeatureSchema> schema = schemas->GetItem(0);
  
  FdoPtr<FdoClassCollection> coll_class = schema->GetClasses();
  long count_classes = coll_class->GetCount();
  
  conn->Close();
  
  
  //CPPUNIT_ASSERT_MESSAGE( "FdoIDescribeSchema:Execute returns 0 spatial contexts " , count );
}
catch(FdoException* ex)
{
  FdoStringP str = ex->GetExceptionMessage();
  ex->Release();
  CPPUNIT_FAIL( (const char*)str );
}
  
}//end of ut_KgOraSdeSchema::DescribeSchema


void ut_KgOraSdeSchema::ReadDataProperty(FdoIReader* Reader,FdoDataType DataType,FdoString* Name)
{
  if( Reader->IsNull(Name) ) return;

  switch(DataType)
  {
    /// Represents a Boolean value of true or false.
  case  FdoDataType_Boolean:
    Reader->GetBoolean(Name);
    break;

    /// Represents unsigned 8-bit integers with values between 0 and 255.
  case FdoDataType_Byte:
    Reader->GetByte(Name);
    break;

    /// Represents a date and time value.
  case FdoDataType_DateTime:
    Reader->GetDateTime(Name);
    break;

    /// Represents values ranging from 1.0 x 10^-28 to approximately 7.9 x 10^28
    /// with 28-29 significant digits.
  case FdoDataType_Decimal:
    Reader->GetDouble(Name);
    break;

    /// Represents a floating point value ranging from approximately 5.0 
    /// x 10^-324 to 1.7 x 10^308 with a precision of 15-16 digits.
  case FdoDataType_Double:
    Reader->GetDouble(Name);
    break;

    /// Represents signed 16-bit integers with values between -32768 and 32767.
  case FdoDataType_Int16:
    Reader->GetInt16(Name);
    break;

    /// Represents signed 32-bit integers with values between -2147483648 
    /// and 2147483647.
  case FdoDataType_Int32:
    Reader->GetInt32(Name);
    break;

    /// Represents signed 64-bit integers with values 
    /// between -9223372036854775808 and 9223372036854775807.
  case FdoDataType_Int64:
    Reader->GetInt64(Name);
    break;

    /// Represents floating point values ranging from approximately 1.5 x 10^-45
    /// to 3.4 x 10^38, with a precision of 7 digits. 
  case FdoDataType_Single:
    Reader->GetSingle(Name);
    break;

    /// Represents a Unicode character strings.
  case FdoDataType_String:
    Reader->GetString(Name);
    break;

    /// Represents a binary large object stored as a collection of bytes.
    case FdoDataType_BLOB:
    Reader->GetLOB(Name);
    break;

    /// Represents a character large object stored as a collection of
    /// characters.
    case FdoDataType_CLOB:
    Reader->GetLOB(Name);
    break;
  }
      

}
void ut_KgOraSdeSchema::ReadAllProperties(FdoIDataReader* Reader)
{
  
  for(int ind=0;ind<Reader->GetPropertyCount();ind++)
  {
    switch(Reader->GetPropertyType(Reader->GetPropertyName(ind)))
    {
      case FdoPropertyType_DataProperty:
      {
        ReadDataProperty(Reader,Reader->GetDataType(Reader->GetPropertyName(ind)),Reader->GetPropertyName(ind));
      }
      break;
      case FdoPropertyType_GeometricProperty:
      {
        if( !Reader->IsNull(Reader->GetPropertyName(ind) ) )
        {
          FdoPtr<FdoByteArray> bytes = Reader->GetGeometry(Reader->GetPropertyName(ind));
          FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( bytes );
          FdoStringP strval=geomval->ToString();
        }
      }
      break;
    
    }
  }
}
void ut_KgOraSdeSchema::ReadAllProperties(FdoIFeatureReader* Reader)
{
  FdoPtr<FdoClassDefinition> fdoclass = Reader->GetClassDefinition();
  FdoPtr<FdoPropertyDefinitionCollection> props = fdoclass->GetProperties();
  
  for(int ind=0;ind<props->GetCount();ind++)
  {
    FdoPtr<FdoPropertyDefinition> prop = props->GetItem(ind);
    switch(prop->GetPropertyType())
    {
      case FdoPropertyType_DataProperty:
      {
        FdoDataPropertyDefinition * dataprop = (FdoDataPropertyDefinition *)prop.p;
        ReadDataProperty(Reader,dataprop->GetDataType(),dataprop->GetName());
      }
      break;
      case FdoPropertyType_GeometricProperty:
      {
        if( !Reader->IsNull(prop->GetName() ) )
        {
          FdoPtr<FdoByteArray> bytes = Reader->GetGeometry(prop->GetName());
          FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( bytes );
          FdoStringP strval=geomval->ToString();
        }
      }
      break;
    }                  
  }
  
}

void ut_KgOraSdeSchema::SelectCommand()
{
try
{
  FdoPtr<FdoIConnection> conn = c_KgOraUtil::OpenUnitTestConn_10_2_SDE();

  c_KgOraConnection* kingora_conn = (c_KgOraConnection*)conn.p;
  
  // create test table with different data types
  FdoPtr<FdoISelect> comm = (FdoISelect*)kingora_conn->CreateCommand(FdoCommandType_Select);
  //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_LICASE_POLY~FdoGeom");
  //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_CGCASE_POLY~FdoGeom");
  
  //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_CCCASE_POINT~FdoGeom");
  //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_DCAPPL_POLY~FdoGeom");
  comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~NEATH_OS_POINT~FdoGeom");
  
  //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_DCAPPL_POLY~FdoGeom");

  // -		testsql	0x089e7778 "GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((406319.018404908 120000, 453680.981595092 120000, 453680.981595092 150000, 406319.018404908 150000, 406319.018404908 120000))')"	const wchar_t *
  // -		testsql	0x088331e8 "GEOMETRY INTERSECTS GeomFromText('POLYGON ((424110.429447853 144969.325153374, 424355.828220859 144969.325153374, 424355.828220859 144723.926380368, 424110.429447853 144723.926380368, 424110.429447853 144969.325153374))')"	const wchar_t *

  // -		testsql	0x03de5d48 "GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((424846.625766871 135378.111192346, 429754.601226994 135378.111192346, 429754.601226994 138486.919482501, 424846.625766871 138486.919482501, 424846.625766871 135378.111192346))')"	const wchar_t *
  //-		testsql	0x0867a888 "GEOMETRY INTERSECTS GeomFromText('POLYGON ((425889.252678089 135994.786865444, 425914.682602753 135994.786865444, 425914.682602753 135969.35694078, 425889.252678089 135969.35694078, 425889.252678089 135994.786865444))')"	const wchar_t *

  //comm->SetFilter(L"SHAPE=50 AND FdoGeom ENVELOPEINTERSECTS GeomFromText('POLYGON ((274278.6 194322.0, 274278.8 194322.0, 274278.8 194322.2, 274278.6 194322.2, 274278.6 194322.0))')");
  //comm->SetFilter(L"DESCGROUP='Terrain And Height' AND FdoGeom ENVELOPEINTERSECTS GeomFromText('POLYGON ((274278.6 194322.0, 274278.8 194322.0, 274278.8 194322.2, 274278.6 194322.2, 274278.6 194322.0))')");
  comm->SetFilter(L"SHAPE=50 AND FdoGeom ENVELOPEINTERSECTS GeomFromText('POLYGON ((274278.6 194322.0, 274278.8 194322.0, 274278.8 194322.2, 274278.6 194322.2, 274278.6 194322.0))')");
  //comm->SetFilter(L"DESCGROUP='Terrain And Height' AND SHAPE=50");
  
  
  

  FdoString *strval;
  int count=0;
  FdoPtr<FdoIFeatureReader> freader = comm->Execute();
  while( freader->ReadNext() )
  {
    ReadAllProperties(freader);
    int shape_id = freader->GetInt32(L"SHAPE");
    FdoString* desc = freader->GetString(L"DESCGROUP");
    //FdoStringP keyval = freader->GetString(L"KEYVAL");
    FdoPtr<FdoByteArray> fgf = freader->GetGeometry(L"FdoGeom");
    FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
    strval=geomval->ToString();
    count++;
  }
  freader->Close();
  
  if( count != 1 ) CPPUNIT_FAIL("only 1 should be in recordset");
}
catch(FdoException* ex)
{
  FdoStringP str = ex->GetExceptionMessage();
  ex->Release();
  CPPUNIT_FAIL( (const char*)str );
}  
}



unsigned char * HexStringToByteArray(char* Str,int& SdeLen)
{
  int lenstr = strlen(Str);

  if( (lenstr % 2) != 0 )
    CPPUNIT_FAIL( "HexStringToByteArray:: Invalid string. Odd number of characters." );
  

  SdeLen = lenstr/2;
  unsigned char byteval;
  unsigned char *sdebinary = new unsigned char[SdeLen];
  unsigned char *dest = sdebinary;
  char *cp = Str;
  while(*cp)
  {
    if( (*cp >= '0') && (*cp <= '9') )
      byteval = *cp - '0';
    else
      byteval = 10 + *cp - 'A';

    byteval = byteval * 16;  
    cp++;
    if( (*cp >= '0') && (*cp <= '9') )
      byteval += *cp - '0';
    else
      byteval += 10 + *cp - 'A';
    cp++;

    *dest++ = byteval;
  }
  
  return sdebinary;
}

char g_SdeString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
char g_SdeString2[] = "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";
void ut_KgOraSdeSchema::SdeBinaryToFGF()
{


  try
  {
    c_SdeGeom2AGF sde2fgf;
    c_KgOraSridDesc srid;

    srid.m_SDE_FalseX = -5220400;
    srid.m_SDE_FalseY = -15524400;
    srid.m_SDE_XYUnit = 10000;
    int sde_len;
    unsigned char* sdebinary = HexStringToByteArray(g_SdeString2,sde_len);
    sde2fgf.SetSdeGeometry(&srid,11,1066,8,sde_len,sdebinary);
    int fgf_len = sde2fgf.ToAGF();
    FdoPtr<FdoByteArray> fgf = FdoByteArray::Create((const unsigned char*)sde2fgf.GetBuff(), fgf_len);
    FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
    FdoString *strval=geomval->ToString();
    delete []sdebinary;
  }
  catch(FdoException* ex)
  {
    FdoStringP str = ex->GetExceptionMessage();
    ex->Release();
    CPPUNIT_FAIL( (const char*)str );
  }  
  
  try
  {
    c_SdeGeom2AGF sde2fgf;
    c_KgOraSridDesc srid;

    srid.m_SDE_FalseX = -5220400;
    srid.m_SDE_FalseY = -15524400;
    srid.m_SDE_XYUnit = 10000;
    int sde_len;
    unsigned char* sdebinary = HexStringToByteArray(g_SdeString,sde_len);
    sde2fgf.SetSdeGeometry(&srid,11,1066,8,sde_len,sdebinary);
    int fgf_len = sde2fgf.ToAGF();
    FdoPtr<FdoByteArray> fgf = FdoByteArray::Create((const unsigned char*)sde2fgf.GetBuff(), fgf_len);
    FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
    FdoString *strval=geomval->ToString();
    delete []sdebinary;
  }
  catch(FdoException* ex)
  {
    FdoStringP str = ex->GetExceptionMessage();
    ex->Release();
    CPPUNIT_FAIL( (const char*)str );
  }  
  
  

  try
  {
    c_SdeGeom2AGF sde2fgf;
    c_KgOraSridDesc srid;

    srid.m_SDE_FalseX = 377166.1095 ;
    srid.m_SDE_FalseY = 795020.8085;
    srid.m_SDE_XYUnit = 10000;
    
    int sde_len;
    //unsigned char* sdebinary = HexStringToByteArray("08000000010000008BE8AC3C83AAFC33",sde_len);
    unsigned char* sdebinary = HexStringToByteArray("0900000001000000A38AE69C01AFC79365",sde_len);
    sde2fgf.SetSdeGeometry(&srid,7,2,8,sde_len,sdebinary);
    int fgf_len = sde2fgf.ToAGF();
    FdoPtr<FdoByteArray> fgf = FdoByteArray::Create((const unsigned char*)sde2fgf.GetBuff(), fgf_len);
    FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
    FdoString *strval=geomval->ToString();
    delete []sdebinary;
  }
  catch(FdoException* ex)
  {
    FdoStringP str = ex->GetExceptionMessage();
    ex->Release();
    CPPUNIT_FAIL( (const char*)str );
  }  
  
  try
  {
    c_SdeGeom2AGF sde2fgf;
    c_KgOraSridDesc srid;

    srid.m_SDE_FalseX = 377166.1095 ;
    srid.m_SDE_FalseY = 795020.8085;
    srid.m_SDE_XYUnit = 10000;

    int sde_len;
    //unsigned char* sdebinary = HexStringToByteArray("0A0000000100000081BAA491018DECF3A001",sde_len);
    unsigned char* sdebinary = HexStringToByteArray("0A00000001000000A1E691A00191B0C38E01",sde_len);
    sde2fgf.SetSdeGeometry(&srid,7,2,8,sde_len,sdebinary);
    int fgf_len = sde2fgf.ToAGF();
    FdoPtr<FdoByteArray> fgf = FdoByteArray::Create((const unsigned char*)sde2fgf.GetBuff(), fgf_len);
    FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
    FdoString *strval=geomval->ToString();
    delete []sdebinary;
  }
  catch(FdoException* ex)
  {
    FdoStringP str = ex->GetExceptionMessage();
    ex->Release();
    CPPUNIT_FAIL( (const char*)str );
  } 
   
}

void ut_KgOraSdeSchema::TestPolygonWithHoles()
{
  try
  {
    FdoPtr<FdoIConnection> conn = c_KgOraUtil::OpenUnitTestConn_10_2_SDE();

    c_KgOraConnection* kingora_conn = (c_KgOraConnection*)conn.p;

    // create test table with different data types
    FdoPtr<FdoISelect> comm = (FdoISelect*)kingora_conn->CreateCommand(FdoCommandType_Select);
    comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~NEATH_OS_AREA~FdoGeom");
    comm->SetFilter(L"SHAPE=139");
    //comm->SetFilter(L"GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((406319.018404908 120000, 453680.981595092 120000, 453680.981595092 150000, 406319.018404908 150000, 406319.018404908 120000))')");
    

    FdoString *strval;
    int count=0;
    FdoPtr<FdoIFeatureReader> freader = comm->Execute();
    while( freader->ReadNext() )
    {
      ReadAllProperties(freader);
      int shape_id = freader->GetInt32(L"SHAPE");
      //FdoStringP keyval = freader->GetString(L"KEYVAL");
      FdoPtr<FdoByteArray> fgf = freader->GetGeometry(L"FdoGeom");
      FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
      strval=geomval->ToString();
      count++;
    }
    freader->Close();
  }
  catch(FdoException* ex)
  {
    FdoStringP str = ex->GetExceptionMessage();
    ex->Release();
    CPPUNIT_FAIL( (const char*)str );
  }  
}

void ut_KgOraSdeSchema::TestBigGeometry()
{
  try
  {
    FdoPtr<FdoIConnection> conn = c_KgOraUtil::OpenUnitTestConn_10_2_SDE();

    c_KgOraConnection* kingora_conn = (c_KgOraConnection*)conn.p;

    // create test table with different data types
    FdoPtr<FdoISelect> comm = (FdoISelect*)kingora_conn->CreateCommand(FdoCommandType_Select);
    comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~NEATH_OS_AREA~FdoGeom");
    comm->SetFilter(L"SHAPE=109");
    //comm->SetFilter(L"GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((406319.018404908 120000, 453680.981595092 120000, 453680.981595092 150000, 406319.018404908 150000, 406319.018404908 120000))')");


    FdoString *strval;
    int count=0;
    FdoPtr<FdoIFeatureReader> freader = comm->Execute();
    while( freader->ReadNext() )
    {
      ReadAllProperties(freader);
      int shape_id = freader->GetInt32(L"SHAPE");
      //FdoStringP keyval = freader->GetString(L"KEYVAL");
      FdoPtr<FdoByteArray> fgf = freader->GetGeometry(L"FdoGeom");
      FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
      strval=geomval->ToString();
      #ifdef DEBUG
      std::cout << strval;
      #endif

      count++;
    }
    freader->Close();
  }
  catch(FdoException* ex)
  {
    FdoStringP str = ex->GetExceptionMessage();
    ex->Release();
    CPPUNIT_FAIL( (const char*)str );
  }  
}

void ut_KgOraSdeSchema::SelectAggregate()
{
  try
  {
    FdoPtr<FdoIConnection> conn = c_KgOraUtil::OpenUnitTestConn_10_2_SDE();

    c_KgOraConnection* kingora_conn = (c_KgOraConnection*)conn.p;

    // create test table with different data types
    FdoPtr<FdoISelectAggregates> comm = (FdoISelectAggregates*)kingora_conn->CreateCommand(FdoCommandType_SelectAggregates);
    //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_LICASE_POLY~FdoGeom");
    //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_CGCASE_POLY~FdoGeom");
    comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_CCCASE_POINT~FdoGeom");
    
    FdoPtr<FdoIdentifierCollection> ids = comm->GetPropertyNames();
    FdoPtr<FdoExpression> expr = FdoExpression::Parse(L"SpatialExtents(FdoGeom)");
    FdoPtr<FdoComputedIdentifier> cid = FdoComputedIdentifier::Create(L"MBR", expr);
    ids->Add(cid);

    // -		testsql	0x089e7778 "GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((406319.018404908 120000, 453680.981595092 120000, 453680.981595092 150000, 406319.018404908 150000, 406319.018404908 120000))')"	const wchar_t *
    // -		testsql	0x088331e8 "GEOMETRY INTERSECTS GeomFromText('POLYGON ((424110.429447853 144969.325153374, 424355.828220859 144969.325153374, 424355.828220859 144723.926380368, 424110.429447853 144723.926380368, 424110.429447853 144969.325153374))')"	const wchar_t *

    // -		testsql	0x03de5d48 "GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((424846.625766871 135378.111192346, 429754.601226994 135378.111192346, 429754.601226994 138486.919482501, 424846.625766871 138486.919482501, 424846.625766871 135378.111192346))')"	const wchar_t *
    //-		testsql	0x0867a888 "GEOMETRY INTERSECTS GeomFromText('POLYGON ((425889.252678089 135994.786865444, 425914.682602753 135994.786865444, 425914.682602753 135969.35694078, 425889.252678089 135969.35694078, 425889.252678089 135994.786865444))')"	const wchar_t *

    //comm->SetFilter(L"GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((406319.018404908 120000, 453680.981595092 120000, 453680.981595092 150000, 406319.018404908 150000, 406319.018404908 120000))')");


    FdoString *strval;
    FdoPtr<FdoIDataReader> freader = comm->Execute();
    while( freader->ReadNext() )
    {
      ReadAllProperties(freader);
      if( !freader->IsNull(L"MBR") )
      {
        FdoPtr<FdoByteArray> fgf = freader->GetGeometry(L"MBR");
        FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
        strval=geomval->ToString();
      }
    }
    freader->Close();
    conn->Close();
  }
  catch(FdoException* ex)
  {
    FdoStringP str = ex->GetExceptionMessage();
    ex->Release();
    CPPUNIT_FAIL( (const char*)str );
  }  
}

void ut_KgOraSdeSchema::ReadAllClassesGeomtries()
{
  try
  {
    FdoPtr<FdoIConnection> conn = c_KgOraUtil::OpenUnitTestConn_10_2_SDE();

    c_KgOraConnection* kingora_conn = (c_KgOraConnection*)conn.p;


    FdoPtr<FdoIDescribeSchema> comm_describe = (FdoIDescribeSchema*)kingora_conn->CreateCommand(FdoCommandType_DescribeSchema);
    FdoPtr<FdoFeatureSchemaCollection> schemas = comm_describe->Execute();
    
    FdoPtr<FdoFeatureSchema> sde_schema = (FdoFeatureSchema*)schemas->FindItem(L"KingOra");
    FdoPtr<FdoClassCollection> classes = sde_schema->GetClasses();
    
    int count = classes->GetCount();
    for(int ind=0;ind<count;ind++)
    {       
      FdoPtr<FdoClassDefinition> fdoclass = classes->GetItem(ind);
      
      // create test table with different data types
      FdoPtr<FdoISelect> comm = (FdoISelect*)kingora_conn->CreateCommand(FdoCommandType_Select);
      comm->SetFeatureClassName(fdoclass->GetName());
      //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_CCCASE_POINT~FdoGeom");

      // -		testsql	0x089e7778 "GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((406319.018404908 120000, 453680.981595092 120000, 453680.981595092 150000, 406319.018404908 150000, 406319.018404908 120000))')"	const wchar_t *
      // -		testsql	0x088331e8 "GEOMETRY INTERSECTS GeomFromText('POLYGON ((424110.429447853 144969.325153374, 424355.828220859 144969.325153374, 424355.828220859 144723.926380368, 424110.429447853 144723.926380368, 424110.429447853 144969.325153374))')"	const wchar_t *

      // -		testsql	0x03de5d48 "GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((424846.625766871 135378.111192346, 429754.601226994 135378.111192346, 429754.601226994 138486.919482501, 424846.625766871 138486.919482501, 424846.625766871 135378.111192346))')"	const wchar_t *
      //-		testsql	0x0867a888 "GEOMETRY INTERSECTS GeomFromText('POLYGON ((425889.252678089 135994.786865444, 425914.682602753 135994.786865444, 425914.682602753 135969.35694078, 425889.252678089 135969.35694078, 425889.252678089 135994.786865444))')"	const wchar_t *

      //comm->SetFilter(L"GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((406319.018404908 120000, 453680.981595092 120000, 453680.981595092 150000, 406319.018404908 150000, 406319.018404908 120000))')");


      FdoPtr<FdoIFeatureReader> freader;
      
      // In this test I wrap up select command into try/catch to ignore exceptions
      // ignore exception is needed because of some classes generated on test database (from 1Spatial) where some sde layers are 
      // coming from oracle views which gives error when trying to execute them (missing tables/schemas in test database)
      try
      {         
        
        freader = comm->Execute();
      }
      catch (FdoException*)
      {
        freader = NULL;
      }
      if( freader.p )
      {
      
        while( freader->ReadNext() )
        {
          ReadAllProperties(freader);
          //FdoPtr<FdoByteArray> fgf = freader->GetGeometry(L"FdoGeom");
          //FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
          //strval=geomval->ToString();
        }
      }
    }
  }
  catch(FdoException* ex)
  {
    FdoStringP str = ex->GetExceptionMessage();
    ex->Release();
    CPPUNIT_FAIL( (const char*)str );
  }  
}


void ut_KgOraSdeSchema::SelectCommand_RemoteSDE()
{
  try
  {
    FdoPtr<FdoIConnection> conn = c_KgOraUtil::OpentConnection(L"Username=unisdetrain;Password=unisde;Service=//193.195.73.43/idoxdb;SDE Schema=SDE;OracleSchema=UNISDETRAIN");    
    

    c_KgOraConnection* kingora_conn = (c_KgOraConnection*)conn.p;

    // create test table with different data types
    FdoPtr<FdoISelect> comm = (FdoISelect*)kingora_conn->CreateCommand(FdoCommandType_Select);
    //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_LICASE_POLY~FdoGeom");
    //comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_CGCASE_POLY~FdoGeom");
    comm->SetFeatureClassName(L"KingOra:UNISDETRAIN~UFRM_CCCASE_POINT~FdoGeom");

    // -		testsql	0x089e7778 "GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((406319.018404908 120000, 453680.981595092 120000, 453680.981595092 150000, 406319.018404908 150000, 406319.018404908 120000))')"	const wchar_t *
    // -		testsql	0x088331e8 "GEOMETRY INTERSECTS GeomFromText('POLYGON ((424110.429447853 144969.325153374, 424355.828220859 144969.325153374, 424355.828220859 144723.926380368, 424110.429447853 144723.926380368, 424110.429447853 144969.325153374))')"	const wchar_t *

    // -		testsql	0x03de5d48 "GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((424846.625766871 135378.111192346, 429754.601226994 135378.111192346, 429754.601226994 138486.919482501, 424846.625766871 138486.919482501, 424846.625766871 135378.111192346))')"	const wchar_t *
    //-		testsql	0x0867a888 "GEOMETRY INTERSECTS GeomFromText('POLYGON ((425889.252678089 135994.786865444, 425914.682602753 135994.786865444, 425914.682602753 135969.35694078, 425889.252678089 135969.35694078, 425889.252678089 135994.786865444))')"	const wchar_t *

    //comm->SetFilter(L"GEOMETRY ENVELOPEINTERSECTS GeomFromText('POLYGON ((406319.018404908 120000, 453680.981595092 120000, 453680.981595092 150000, 406319.018404908 150000, 406319.018404908 120000))')");


    FdoString *strval;
    FdoPtr<FdoIFeatureReader> freader = comm->Execute();
    while( freader->ReadNext() )
    {
      ReadAllProperties(freader);
      FdoPtr<FdoByteArray> fgf = freader->GetGeometry(L"FdoGeom");
      FdoPtr<FdoGeometryValue> geomval = FdoGeometryValue::Create( fgf );
      strval=geomval->ToString();
    }
    freader->Close();
  }
  catch(FdoException* ex)
  {
    FdoStringP str = ex->GetExceptionMessage();
    ex->Release();
    CPPUNIT_FAIL( (const char*)str );
  }  
}