/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "Pch.h"
#include "ABasicOpenTests.h"

CPPUNIT_TEST_SUITE_REGISTRATION (ABasicOpenTests);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION (ABasicOpenTests, "ABasicOpenTests");

ABasicOpenTests::ABasicOpenTests(void)
{
}

ABasicOpenTests::~ABasicOpenTests(void)
{
}

void ABasicOpenTests::setUp ()
{
}

void ABasicOpenTests::tearDown ()
{
}

/* Test basic direct connection.
   NOTE: SDEHOME environment variable must be set to the ArcGIS\ArcSDE directory:
        C:>set SDEHOME=D:\reliant\ArcGIS\ArcSDE\Windows
   and there must also be an OTWE1_R9204 entry in your TNSNAMES.ORA file:
        OTWE1_R9204.AMER.ADS.AUTODESK.COM =
        (DESCRIPTION =
            (ADDRESS_LIST =
            (ADDRESS = (PROTOCOL = TCP)(HOST = otwe1)(PORT = 1521))
            )
            (CONNECT_DATA =
            (SERVICE_NAME = r9204)
            )
        )
*/
void ABasicOpenTests::basic_direct ()
{
    if (CreateSchemaOnly())  return;
    
#if 0
    try
    {
        FdoPtr<FdoIConnection> connection = ArcSDETests::GetConnection ();

        // Connect without "Datastore" property set:
        CPPUNIT_ASSERT_MESSAGE("Connection state should be 'closed'", connection->GetConnectionState() == FdoConnectionState_Closed);
        connection->SetConnectionString (ArcSDETestConfig::ConnStringDirectConnect());  // direct connect
        //connection->SetConnectionString (ArcSDETestConfig::ConnStringSdeWithDatastore());  // indirect connect
        connection->Open ();
        CPPUNIT_ASSERT_MESSAGE("Connection state should be 'pending'", connection->GetConnectionState() == FdoConnectionState_Pending);

        // Set "Datastore" connection property:
        FdoPtr<FdoIConnectionInfo> pConnInfo = connection->GetConnectionInfo ();
        FdoPtr<FdoIConnectionPropertyDictionary> pConnDictionary = pConnInfo->GetConnectionProperties();
        CPPUNIT_ASSERT_MESSAGE("Datastore connection property should be enumerable", pConnDictionary->IsPropertyEnumerable(L"Datastore"));
        FdoInt32 numDatastores = 0;
        FdoString **datastoreNames = pConnDictionary->EnumeratePropertyValues(L"Datastore", numDatastores);
        CPPUNIT_ASSERT_MESSAGE("Should be at least 1 datastore at any time", numDatastores >= 1);
        pConnDictionary->SetProperty(L"Datastore", datastoreNames[0]);  // pick first datastore

        // Re-connect, with "Datastore" connection property set this time:
        connection->Open ();  // re-open with all connection properties set
        CPPUNIT_ASSERT_MESSAGE("Connection state should be 'open'", connection->GetConnectionState() == FdoConnectionState_Open);

        // Close
        connection->Close ();
        CPPUNIT_ASSERT_MESSAGE("Connection state should be 'closed'", connection->GetConnectionState() == FdoConnectionState_Closed);
    }
    catch (FdoException* ge)
    {
        fail (ge);
    }
#endif
}

/* Test basic application server connection. */
void ABasicOpenTests::basic_indirect ()
{
    if (CreateSchemaOnly())  return;

    try
    {
        FdoPtr<FdoIConnection> connection = ArcSDETests::GetConnection ();
        FdoPtr<FdoIConnectionInfo> pConnInfo = connection->GetConnectionInfo ();
        FdoPtr<FdoIConnectionPropertyDictionary> pConnDictionary = pConnInfo->GetConnectionProperties();

        // Connect without "Datastore" property set:
        CPPUNIT_ASSERT_MESSAGE("Connection state should be 'closed'", connection->GetConnectionState() == FdoConnectionState_Closed);
        connection->SetConnectionString (ArcSDETestConfig::ConnStringSdeNodatastore());
        connection->Open ();
        CPPUNIT_ASSERT_MESSAGE("Connection state should be 'pending'", connection->GetConnectionState() == FdoConnectionState_Pending);

        // Set "Datastore" connection property:
        CPPUNIT_ASSERT_MESSAGE("Datastore connection property should be enumerable", pConnDictionary->IsPropertyEnumerable(L"Datastore"));
        FdoInt32 numDatastores = 0;
        FdoString **datastoreNames = pConnDictionary->EnumeratePropertyValues(L"Datastore", numDatastores);
        CPPUNIT_ASSERT_MESSAGE("Should be at least 1 datastore at any time", numDatastores >= 1);
        pConnDictionary->SetProperty(L"Datastore", ArcSDETestConfig::Datastore());

        // Re-get the connection string, make sure it contains the right stuff:
        FdoString* connString2 = connection->GetConnectionString();
        CPPUNIT_ASSERT_MESSAGE("Wrong connection string after calling SetProperty()",
            0==wcscmp(connString2, ArcSDETestConfig::ConnStringSdeWithDatastore()));

        // Re-connect, with "Datastore" connection property set this time:
        connection->Open ();  // re-open with all connection properties set
        CPPUNIT_ASSERT_MESSAGE("Connection state should be 'open'", connection->GetConnectionState() == FdoConnectionState_Open);

        // Close
        connection->Close ();
        CPPUNIT_ASSERT_MESSAGE("Connection state should be 'closed'", connection->GetConnectionState() == FdoConnectionState_Closed);
    }
    catch (FdoException* ge)
    {
        fail (ge);
    }
}

/* Test open failure with no runtime. */
void ABasicOpenTests::no_runtime ()
{
    if (CreateSchemaOnly())  return;

    try
    {
        FdoPtr<FdoIConnection> connection = ArcSDETests::GetConnection ();
        connection->SetConnectionString (ArcSDETestConfig::ConnStringAustralia());
        connection->Open ();
        connection->Close ();
    }
    catch (FdoException* e)
    {
        // expected response with no runtime
        wprintf (e->GetExceptionMessage ());
        e->Release ();
    }
    catch (...)
    {
        CPPUNIT_FAIL ("non-FdoException");
    }
}


void ABasicOpenTests::list_datastores ()
{
    if (CreateSchemaOnly())  return;

    try
    {
        FdoPtr<FdoIConnection> connection = ArcSDETests::GetConnection ();
        connection->SetConnectionString (ArcSDETestConfig::ConnStringSdeNodatastore());
        CPPUNIT_ASSERT_MESSAGE("Connection state should be pending", FdoConnectionState_Pending==connection->Open());

        // Fetch list of datastores:

        FdoPtr<FdoIListDataStores> listDatastores = (FdoIListDataStores*)connection->CreateCommand(FdoCommandType_ListDataStores);
        FdoPtr<FdoIDataStoreReader> dsReader = listDatastores->Execute();
        while (dsReader->ReadNext())
        {
            // Test FdoIDataStorePropertyDictionary-specific calls:
            FdoString* dsName = dsReader->GetName();
            FdoString* desc = dsReader->GetDescription();
            bool dsFdoEnabled = dsReader->GetIsFdoEnabled();
            FdoPtr<FdoIDataStorePropertyDictionary> dsProps = dsReader->GetDataStoreProperties();

            // Test a few generic FdoIPropertyDictionary calls:
            FdoString* dsName2 = dsProps->GetProperty(L"Datastore");
            FdoString* localizedName = dsProps->GetLocalizedName(L"Datastore");
            bool bIsDataStore = dsProps->IsPropertyDatastoreName(L"Datastore");
        }

        connection->Close ();
    }
    catch (FdoException* e)
    {
        // expected response with no runtime
        wprintf (e->GetExceptionMessage ());
        e->Release ();
    }
}

