// ParseSchemaDefinitionFile.h


#ifndef _PARSESCHEMADEFINITIONFILE_H_
#define _PARSESCHEMADEFINITIONFILE_H_
// 
// 
//  
//  Copyright (C) 2008  Autodesk, Inc.
//  
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//  
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//  

#include "Logger.h"
#include "conversions.h"
#include <wchar.h>
#include <istream>
#include <fstream>
#include <string>
#include <cstring>
#include <iostream>
#include "ParseSchemaOperationFile.h"

class ParseSchemaDefinitionFile : public ParseSchemaOperationFile {
public:
	ParseSchemaDefinitionFile(const char * schemaFileName, Logger * log, Conversions * convert);
	~ParseSchemaDefinitionFile();
	int getNameValue();
	int GetNextSchema();
	int GetNextClass();
	int GetNextProperty();
	const wchar_t * GetSchemaDescription();
	const wchar_t * GetClassDescription();
	const char * GetClassType();
	bool GetClassAbstract();
	bool GetClassComputed();
	const wchar_t * GetPropertyName();
	const wchar_t * GetPropertyDescription();
	const char * GetPropertyType();
	const char * GetPropertyDataType();
	const char * GetPropertyGeometricTypes();
	bool GetPropertyReadOnly();
	bool GetPropertyNullable();
	bool GetPropertyAutoGenerated();
	bool GetPropertyIdentity();
	bool GetPropertyHasElevation();
	bool GetPropertyHasMeasure();
	int GetPropertyLength();
	int GetPropertyCount();

private:
	wstring * schemaDescription;
	wstring * classDescription;
	string * classType;
	bool classAbstract;
	bool classComputed;
	wstring * propertyName;
	wstring * propertyDescription;
	string * propertyType;
	bool propertyReadOnly;
	bool propertyNullable;
	string * propertyDataType;
	string * propertyGeometricTypes;
	bool propertyAutoGenerated;
	bool propertyIdentity;
	int propertyLength;
	bool propertyHasElevation;
	bool propertyHasMeasure;
	int propertyCount;

	void initSchema();
	void initClass();
	void initProperty();

	void initSchemaOtherProperties();
	void initClassOtherProperties();
	void constructionInit();
	void deconstructionDelete();
	int storeNameValue(char * name, char * value);

};

#endif
