/*! \mainpage Introduction
<div class="mainpage">
<!-- This is the index.html page that the user first sees. -->

<p>The Feature Data Objects (FDO) API provides access to data in a 
data store. A provider is a specific implementation of the FDO API 
that provides access to data in a particular data store. The FDO 
Provider for WMS provides FDO with access to a WMS-based data store.
</p>
<p>An Open Geospatial Consortium (OGC) Web Map Service (WMS)
produces maps of spatially referenced data dynamically from
geographic information. This international standard defines a
"map" to be a portrayal of geographic information as a
digital image file suitable for display on a computer screen.
A map is not the data itself. Maps by WMS are generally
rendered in a pictorial format, such as PNG, GIF or JPEG, or 
occasionally as vector-based graphical elements in Scalable
Vector Graphics (SVG) or Web Computer Graphics Metafile
(WebCGM) formats.

<p>The FDO Provider for WMS has the following characteristics: 
</p>
<ul>
  <li> The FDO Provider for WMS serves up map information originating 
  from an OGC Basic Web Map Service that provides pictorially formatted 
  images, such as PNG, GIF, or JPEG. 
  <li> WMS map data is exposed through an FDO feature schema whose classes 
  contain an FDO Raster property definition. The FDO schema exposed from 
  the FDO Provider for WMS conforms to a pre-defined FDO schema that is 
  specific to WMS and that acts as the basis for all FDO interaction with 
  WMS data, regardless of the originating source of the WMS images.
  <li> WMS data manipulation operations are limited to querying features 
  based on spatial and non-spatial constraints. Schema manipulation 
  operations are not supported.
</ul>
<p>The FDO Provider for WMS can run in a multi-platform environment, 
including Windows and Linux.
</p>
<p>
For more information, see <i>The Essential FDO</i> 
and the <i>FDO Developer's Guide</i>.
</p>

<br>
</div>
*/




