#ifndef FDOSMPHODBCCOLTYPEMAPPER_H
#define FDOSMPHODBCCOLTYPEMAPPER_H       1
/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef _WIN32
#pragma once
#endif

#include <Sm/NamedCollection.h>
#include <Sm/Ph/Coltype.h>

// Lists all FDO Property types with their corresponding
// enum facet and string representations.
class FdoSmPhOdbcColTypeMapper
{
public:
    FdoSmPhOdbcColTypeMapper(void);
    ~FdoSmPhOdbcColTypeMapper(void);

    // Converts string to facet
    //
    // Parameters:
    //      colTypeString: the string.
    static FdoSmPhColType String2Type(
        FdoString* colTypeString,
        int size = 0,
        int scale = 0
    );
    // Converts facet to string
    static FdoStringP Type2String( FdoSmPhColType colType );
};

#endif
