/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


#include "stdafx.h"

#include <Rdbms/Override/MySQL/MySqlOvObjectPropertyDefinition.h>

FdoMySQLOvObjectPropertyDefinition* FdoMySQLOvObjectPropertyDefinition::Create()
{
    return new FdoMySQLOvObjectPropertyDefinition();
}

FdoMySQLOvObjectPropertyDefinition* FdoMySQLOvObjectPropertyDefinition::Create(FdoString* name)
{
    return new FdoMySQLOvObjectPropertyDefinition(name);
}

FdoMySQLOvObjectPropertyDefinition::FdoMySQLOvObjectPropertyDefinition()
{
}

FdoMySQLOvObjectPropertyDefinition::FdoMySQLOvObjectPropertyDefinition(FdoString* name) :
    FdoRdbmsOvPropertyDefinition(name),
    FdoRdbmsOvObjectPropertyDefinition(name),
    FdoMySQLOvPropertyDefinition(name)
{
}

FdoMySQLOvObjectPropertyDefinition::~FdoMySQLOvObjectPropertyDefinition()
{
}

FdoMySQLOvPropertyMappingDefinition* FdoMySQLOvObjectPropertyDefinition::GetMappingDefinition()
{
    return dynamic_cast<FdoMySQLOvPropertyMappingDefinition*>(FdoRdbmsOvObjectPropertyDefinition::GetMappingDefinition());
}

void FdoMySQLOvObjectPropertyDefinition::SetMappingDefinition(FdoMySQLOvPropertyMappingDefinition* propertyMappingDefinition)
{
    FdoRdbmsOvObjectPropertyDefinition::SetMappingDefinition( propertyMappingDefinition );
}

void FdoMySQLOvObjectPropertyDefinition::Dispose()
{
    delete this;
}

FdoRdbmsOvPropertyMappingSingle* FdoMySQLOvObjectPropertyDefinition::CreateSingleMapping(
    bool attach
)
{
    FdoMySQLOvPropertyMappingSingleP pMapping = FdoMySQLOvPropertyMappingSingle::Create();
    if ( attach ) 
        SetMappingDefinition( pMapping );

    return FDO_SAFE_ADDREF(dynamic_cast<FdoRdbmsOvPropertyMappingSingle*>(pMapping.p));
}

FdoRdbmsOvPropertyMappingClass* FdoMySQLOvObjectPropertyDefinition::CreateClassMapping(
    bool attach
)
{
    FdoMySQLOvPropertyMappingClassP pMapping = FdoMySQLOvPropertyMappingClass::Create();
    if ( attach ) 
        SetMappingDefinition( pMapping );

    return FDO_SAFE_ADDREF(dynamic_cast<FdoRdbmsOvPropertyMappingClass*>(pMapping.p));
}

FdoRdbmsOvPropertyMappingConcrete* FdoMySQLOvObjectPropertyDefinition::CreateConcreteMapping(
    bool attach
)
{
    FdoMySQLOvPropertyMappingConcreteP pMapping = FdoMySQLOvPropertyMappingConcrete::Create();
    if ( attach ) 
        SetMappingDefinition( pMapping );

    return FDO_SAFE_ADDREF(dynamic_cast<FdoRdbmsOvPropertyMappingConcrete*>(pMapping.p));
}

