// Copyright (c) 2023 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=2b8d7a22d62b14176b5e7a9be38c7948544c71b6$
//

#include "libcef_dll/cpptoc/test/translator_test_cpptoc.h"
#include <algorithm>
#include "libcef_dll/cpptoc/test/translator_test_ref_ptr_library_child_cpptoc.h"
#include "libcef_dll/cpptoc/test/translator_test_ref_ptr_library_cpptoc.h"
#include "libcef_dll/cpptoc/test/translator_test_scoped_library_child_cpptoc.h"
#include "libcef_dll/cpptoc/test/translator_test_scoped_library_cpptoc.h"
#include "libcef_dll/ctocpp/test/translator_test_ref_ptr_client_child_ctocpp.h"
#include "libcef_dll/ctocpp/test/translator_test_ref_ptr_client_ctocpp.h"
#include "libcef_dll/ctocpp/test/translator_test_scoped_client_child_ctocpp.h"
#include "libcef_dll/ctocpp/test/translator_test_scoped_client_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"
#include "libcef_dll/transfer_util.h"

// GLOBAL FUNCTIONS - Body may be edited by hand.

CEF_EXPORT cef_translator_test_t* cef_translator_test_create() {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  CefRefPtr<CefTranslatorTest> _retval = CefTranslatorTest::Create();

  // Return type: refptr_same
  return CefTranslatorTestCppToC::Wrap(_retval);
}

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

void CEF_CALLBACK
translator_test_get_void(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefTranslatorTestCppToC::Get(self)->GetVoid();
}

int CEF_CALLBACK translator_test_get_bool(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->GetBool();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK translator_test_get_int(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->GetInt();

  // Return type: simple
  return _retval;
}

double CEF_CALLBACK
translator_test_get_double(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  double _retval = CefTranslatorTestCppToC::Get(self)->GetDouble();

  // Return type: simple
  return _retval;
}

long CEF_CALLBACK
translator_test_get_long(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  long _retval = CefTranslatorTestCppToC::Get(self)->GetLong();

  // Return type: simple
  return _retval;
}

size_t CEF_CALLBACK
translator_test_get_sizet(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  size_t _retval = CefTranslatorTestCppToC::Get(self)->GetSizet();

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK translator_test_set_void(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetVoid();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK translator_test_set_bool(struct _cef_translator_test_t* self,
                                          int val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval =
      CefTranslatorTestCppToC::Get(self)->SetBool(val ? true : false);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK translator_test_set_int(struct _cef_translator_test_t* self,
                                         int val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetInt(val);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK translator_test_set_double(struct _cef_translator_test_t* self,
                                            double val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetDouble(val);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK translator_test_set_long(struct _cef_translator_test_t* self,
                                          long val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetLong(val);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK translator_test_set_sizet(struct _cef_translator_test_t* self,
                                           size_t val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetSizet(val);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
translator_test_set_int_list(struct _cef_translator_test_t* self,
                             size_t valCount,
                             int const* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: simple_vec_byref_const
  DCHECK(valCount == 0 || val);
  if (valCount > 0 && !val) {
    return 0;
  }

  // Translate param: val; type: simple_vec_byref_const
  std::vector<int> valList;
  if (valCount > 0) {
    for (size_t i = 0; i < valCount; ++i) {
      int valVal = val[i];
      valList.push_back(valVal);
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetIntList(valList);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
translator_test_get_int_list_by_ref(struct _cef_translator_test_t* self,
                                    size_t* valCount,
                                    int* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: simple_vec_byref
  DCHECK(valCount && (*valCount == 0 || val));
  if (!valCount || (*valCount > 0 && !val)) {
    return 0;
  }

  // Translate param: val; type: simple_vec_byref
  std::vector<int> valList;
  if (valCount && *valCount > 0 && val) {
    for (size_t i = 0; i < *valCount; ++i) {
      valList.push_back(val[i]);
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->GetIntListByRef(valList);

  // Restore param: val; type: simple_vec_byref
  if (valCount && val) {
    *valCount = std::min(valList.size(), *valCount);
    if (*valCount > 0) {
      for (size_t i = 0; i < *valCount; ++i) {
        val[i] = valList[i];
      }
    }
  }

  // Return type: bool
  return _retval;
}

size_t CEF_CALLBACK
translator_test_get_int_list_size(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  size_t _retval = CefTranslatorTestCppToC::Get(self)->GetIntListSize();

  // Return type: simple
  return _retval;
}

cef_string_userfree_t CEF_CALLBACK
translator_test_get_string(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefTranslatorTestCppToC::Get(self)->GetString();

  // Return type: string
  return _retval.DetachToUserFree();
}

int CEF_CALLBACK translator_test_set_string(struct _cef_translator_test_t* self,
                                            const cef_string_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: string_byref_const
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetString(CefString(val));

  // Return type: bool
  return _retval;
}

void CEF_CALLBACK
translator_test_get_string_by_ref(struct _cef_translator_test_t* self,
                                  cef_string_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: val; type: string_byref
  DCHECK(val);
  if (!val) {
    return;
  }

  // Translate param: val; type: string_byref
  CefString valStr(val);

  // Execute
  CefTranslatorTestCppToC::Get(self)->GetStringByRef(valStr);
}

int CEF_CALLBACK
translator_test_set_string_list(struct _cef_translator_test_t* self,
                                cef_string_list_t val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: string_vec_byref_const
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: string_vec_byref_const
  std::vector<CefString> valList;
  transfer_string_list_contents(val, valList);

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetStringList(valList);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
translator_test_get_string_list_by_ref(struct _cef_translator_test_t* self,
                                       cef_string_list_t val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: string_vec_byref
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: string_vec_byref
  std::vector<CefString> valList;
  transfer_string_list_contents(val, valList);

  // Execute
  bool _retval =
      CefTranslatorTestCppToC::Get(self)->GetStringListByRef(valList);

  // Restore param: val; type: string_vec_byref
  cef_string_list_clear(val);
  transfer_string_list_contents(valList, val);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
translator_test_set_string_map(struct _cef_translator_test_t* self,
                               cef_string_map_t val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: string_map_single_byref_const
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: string_map_single_byref_const
  std::map<CefString, CefString> valMap;
  transfer_string_map_contents(val, valMap);

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetStringMap(valMap);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
translator_test_get_string_map_by_ref(struct _cef_translator_test_t* self,
                                      cef_string_map_t val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: string_map_single_byref
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: string_map_single_byref
  std::map<CefString, CefString> valMap;
  transfer_string_map_contents(val, valMap);

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->GetStringMapByRef(valMap);

  // Restore param: val; type: string_map_single_byref
  cef_string_map_clear(val);
  transfer_string_map_contents(valMap, val);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
translator_test_set_string_multimap(struct _cef_translator_test_t* self,
                                    cef_string_multimap_t val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: string_map_multi_byref_const
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: string_map_multi_byref_const
  std::multimap<CefString, CefString> valMultimap;
  transfer_string_multimap_contents(val, valMultimap);

  // Execute
  bool _retval =
      CefTranslatorTestCppToC::Get(self)->SetStringMultimap(valMultimap);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
translator_test_get_string_multimap_by_ref(struct _cef_translator_test_t* self,
                                           cef_string_multimap_t val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: string_map_multi_byref
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: string_map_multi_byref
  std::multimap<CefString, CefString> valMultimap;
  transfer_string_multimap_contents(val, valMultimap);

  // Execute
  bool _retval =
      CefTranslatorTestCppToC::Get(self)->GetStringMultimapByRef(valMultimap);

  // Restore param: val; type: string_map_multi_byref
  cef_string_multimap_clear(val);
  transfer_string_multimap_contents(valMultimap, val);

  // Return type: bool
  return _retval;
}

cef_point_t CEF_CALLBACK
translator_test_get_point(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefPoint();
  }

  // Execute
  cef_point_t _retval = CefTranslatorTestCppToC::Get(self)->GetPoint();

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK translator_test_set_point(struct _cef_translator_test_t* self,
                                           const cef_point_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: simple_byref_const
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: simple_byref_const
  CefPoint valVal = val ? *val : CefPoint();

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetPoint(valVal);

  // Return type: bool
  return _retval;
}

void CEF_CALLBACK
translator_test_get_point_by_ref(struct _cef_translator_test_t* self,
                                 cef_point_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: val; type: simple_byref
  DCHECK(val);
  if (!val) {
    return;
  }

  // Translate param: val; type: simple_byref
  CefPoint valVal = val ? *val : CefPoint();

  // Execute
  CefTranslatorTestCppToC::Get(self)->GetPointByRef(valVal);

  // Restore param: val; type: simple_byref
  if (val) {
    *val = valVal;
  }
}

int CEF_CALLBACK
translator_test_set_point_list(struct _cef_translator_test_t* self,
                               size_t valCount,
                               cef_point_t const* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: simple_vec_byref_const
  DCHECK(valCount == 0 || val);
  if (valCount > 0 && !val) {
    return 0;
  }

  // Translate param: val; type: simple_vec_byref_const
  std::vector<CefPoint> valList;
  if (valCount > 0) {
    for (size_t i = 0; i < valCount; ++i) {
      CefPoint valVal = val[i];
      valList.push_back(valVal);
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetPointList(valList);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
translator_test_get_point_list_by_ref(struct _cef_translator_test_t* self,
                                      size_t* valCount,
                                      cef_point_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: simple_vec_byref
  DCHECK(valCount && (*valCount == 0 || val));
  if (!valCount || (*valCount > 0 && !val)) {
    return 0;
  }

  // Translate param: val; type: simple_vec_byref
  std::vector<CefPoint> valList;
  if (valCount && *valCount > 0 && val) {
    for (size_t i = 0; i < *valCount; ++i) {
      valList.push_back(val[i]);
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->GetPointListByRef(valList);

  // Restore param: val; type: simple_vec_byref
  if (valCount && val) {
    *valCount = std::min(valList.size(), *valCount);
    if (*valCount > 0) {
      for (size_t i = 0; i < *valCount; ++i) {
        val[i] = valList[i];
      }
    }
  }

  // Return type: bool
  return _retval;
}

size_t CEF_CALLBACK
translator_test_get_point_list_size(struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  size_t _retval = CefTranslatorTestCppToC::Get(self)->GetPointListSize();

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_ref_ptr_library_t* CEF_CALLBACK
translator_test_get_ref_ptr_library(struct _cef_translator_test_t* self,
                                    int val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefTranslatorTestRefPtrLibrary> _retval =
      CefTranslatorTestCppToC::Get(self)->GetRefPtrLibrary(val);

  // Return type: refptr_same
  return CefTranslatorTestRefPtrLibraryCppToC::Wrap(_retval);
}

int CEF_CALLBACK translator_test_set_ref_ptr_library(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_ref_ptr_library_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: refptr_same
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->SetRefPtrLibrary(
      CefTranslatorTestRefPtrLibraryCppToC::Unwrap(val));

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_ref_ptr_library_t* CEF_CALLBACK
translator_test_set_ref_ptr_library_and_return(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_ref_ptr_library_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: val; type: refptr_same
  DCHECK(val);
  if (!val) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefTranslatorTestRefPtrLibrary> _retval =
      CefTranslatorTestCppToC::Get(self)->SetRefPtrLibraryAndReturn(
          CefTranslatorTestRefPtrLibraryCppToC::Unwrap(val));

  // Return type: refptr_same
  return CefTranslatorTestRefPtrLibraryCppToC::Wrap(_retval);
}

int CEF_CALLBACK translator_test_set_child_ref_ptr_library(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_ref_ptr_library_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: refptr_same
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->SetChildRefPtrLibrary(
      CefTranslatorTestRefPtrLibraryChildCppToC::Unwrap(val));

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_ref_ptr_library_t* CEF_CALLBACK
translator_test_set_child_ref_ptr_library_and_return_parent(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_ref_ptr_library_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: val; type: refptr_same
  DCHECK(val);
  if (!val) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefTranslatorTestRefPtrLibrary> _retval =
      CefTranslatorTestCppToC::Get(self)->SetChildRefPtrLibraryAndReturnParent(
          CefTranslatorTestRefPtrLibraryChildCppToC::Unwrap(val));

  // Return type: refptr_same
  return CefTranslatorTestRefPtrLibraryCppToC::Wrap(_retval);
}

int CEF_CALLBACK translator_test_set_ref_ptr_library_list(
    struct _cef_translator_test_t* self,
    size_t valCount,
    struct _cef_translator_test_ref_ptr_library_t* const* val,
    int val1,
    int val2) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: refptr_vec_same_byref_const
  DCHECK(valCount == 0 || val);
  if (valCount > 0 && !val) {
    return 0;
  }

  // Translate param: val; type: refptr_vec_same_byref_const
  std::vector<CefRefPtr<CefTranslatorTestRefPtrLibrary>> valList;
  if (valCount > 0) {
    for (size_t i = 0; i < valCount; ++i) {
      CefRefPtr<CefTranslatorTestRefPtrLibrary> valVal =
          CefTranslatorTestRefPtrLibraryCppToC::Unwrap(val[i]);
      valList.push_back(valVal);
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetRefPtrLibraryList(
      valList, val1, val2);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK translator_test_get_ref_ptr_library_list_by_ref(
    struct _cef_translator_test_t* self,
    size_t* valCount,
    struct _cef_translator_test_ref_ptr_library_t** val,
    int val1,
    int val2) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: refptr_vec_same_byref
  DCHECK(valCount && (*valCount == 0 || val));
  if (!valCount || (*valCount > 0 && !val)) {
    return 0;
  }

  // Translate param: val; type: refptr_vec_same_byref
  std::vector<CefRefPtr<CefTranslatorTestRefPtrLibrary>> valList;
  if (valCount && *valCount > 0 && val) {
    for (size_t i = 0; i < *valCount; ++i) {
      valList.push_back(CefTranslatorTestRefPtrLibraryCppToC::Unwrap(val[i]));
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->GetRefPtrLibraryListByRef(
      valList, val1, val2);

  // Restore param: val; type: refptr_vec_same_byref
  if (valCount && val) {
    *valCount = std::min(valList.size(), *valCount);
    if (*valCount > 0) {
      for (size_t i = 0; i < *valCount; ++i) {
        val[i] = CefTranslatorTestRefPtrLibraryCppToC::Wrap(valList[i]);
      }
    }
  }

  // Return type: bool
  return _retval;
}

size_t CEF_CALLBACK translator_test_get_ref_ptr_library_list_size(
    struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  size_t _retval =
      CefTranslatorTestCppToC::Get(self)->GetRefPtrLibraryListSize();

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK translator_test_set_ref_ptr_client(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_ref_ptr_client_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: refptr_diff
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->SetRefPtrClient(
      CefTranslatorTestRefPtrClientCToCpp::Wrap(val));

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_ref_ptr_client_t* CEF_CALLBACK
translator_test_set_ref_ptr_client_and_return(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_ref_ptr_client_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: val; type: refptr_diff
  DCHECK(val);
  if (!val) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefTranslatorTestRefPtrClient> _retval =
      CefTranslatorTestCppToC::Get(self)->SetRefPtrClientAndReturn(
          CefTranslatorTestRefPtrClientCToCpp::Wrap(val));

  // Return type: refptr_diff
  return CefTranslatorTestRefPtrClientCToCpp::Unwrap(_retval);
}

int CEF_CALLBACK translator_test_set_child_ref_ptr_client(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_ref_ptr_client_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: refptr_diff
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->SetChildRefPtrClient(
      CefTranslatorTestRefPtrClientChildCToCpp::Wrap(val));

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_ref_ptr_client_t* CEF_CALLBACK
translator_test_set_child_ref_ptr_client_and_return_parent(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_ref_ptr_client_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: val; type: refptr_diff
  DCHECK(val);
  if (!val) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefTranslatorTestRefPtrClient> _retval =
      CefTranslatorTestCppToC::Get(self)->SetChildRefPtrClientAndReturnParent(
          CefTranslatorTestRefPtrClientChildCToCpp::Wrap(val));

  // Return type: refptr_diff
  return CefTranslatorTestRefPtrClientCToCpp::Unwrap(_retval);
}

int CEF_CALLBACK translator_test_set_ref_ptr_client_list(
    struct _cef_translator_test_t* self,
    size_t valCount,
    struct _cef_translator_test_ref_ptr_client_t* const* val,
    int val1,
    int val2) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: refptr_vec_diff_byref_const
  DCHECK(valCount == 0 || val);
  if (valCount > 0 && !val) {
    return 0;
  }

  // Translate param: val; type: refptr_vec_diff_byref_const
  std::vector<CefRefPtr<CefTranslatorTestRefPtrClient>> valList;
  if (valCount > 0) {
    for (size_t i = 0; i < valCount; ++i) {
      CefRefPtr<CefTranslatorTestRefPtrClient> valVal =
          CefTranslatorTestRefPtrClientCToCpp::Wrap(val[i]);
      valList.push_back(valVal);
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetRefPtrClientList(
      valList, val1, val2);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK translator_test_get_ref_ptr_client_list_by_ref(
    struct _cef_translator_test_t* self,
    size_t* valCount,
    struct _cef_translator_test_ref_ptr_client_t** val,
    struct _cef_translator_test_ref_ptr_client_t* val1,
    struct _cef_translator_test_ref_ptr_client_t* val2) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: refptr_vec_diff_byref
  DCHECK(valCount && (*valCount == 0 || val));
  if (!valCount || (*valCount > 0 && !val)) {
    return 0;
  }
  // Verify param: val1; type: refptr_diff
  DCHECK(val1);
  if (!val1) {
    return 0;
  }
  // Verify param: val2; type: refptr_diff
  DCHECK(val2);
  if (!val2) {
    return 0;
  }

  // Translate param: val; type: refptr_vec_diff_byref
  std::vector<CefRefPtr<CefTranslatorTestRefPtrClient>> valList;
  if (valCount && *valCount > 0 && val) {
    for (size_t i = 0; i < *valCount; ++i) {
      valList.push_back(CefTranslatorTestRefPtrClientCToCpp::Wrap(val[i]));
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->GetRefPtrClientListByRef(
      valList, CefTranslatorTestRefPtrClientCToCpp::Wrap(val1),
      CefTranslatorTestRefPtrClientCToCpp::Wrap(val2));

  // Restore param: val; type: refptr_vec_diff_byref
  if (valCount && val) {
    *valCount = std::min(valList.size(), *valCount);
    if (*valCount > 0) {
      for (size_t i = 0; i < *valCount; ++i) {
        val[i] = CefTranslatorTestRefPtrClientCToCpp::Unwrap(valList[i]);
      }
    }
  }

  // Return type: bool
  return _retval;
}

size_t CEF_CALLBACK translator_test_get_ref_ptr_client_list_size(
    struct _cef_translator_test_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  size_t _retval =
      CefTranslatorTestCppToC::Get(self)->GetRefPtrClientListSize();

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_scoped_library_t* CEF_CALLBACK
translator_test_get_own_ptr_library(struct _cef_translator_test_t* self,
                                    int val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefOwnPtr<CefTranslatorTestScopedLibrary> _retval =
      CefTranslatorTestCppToC::Get(self)->GetOwnPtrLibrary(val);

  // Return type: ownptr_same
  return CefTranslatorTestScopedLibraryCppToC::WrapOwn(std::move(_retval));
}

int CEF_CALLBACK translator_test_set_own_ptr_library(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_library_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: ownptr_same
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->SetOwnPtrLibrary(
      CefTranslatorTestScopedLibraryCppToC::UnwrapOwn(val));

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_scoped_library_t* CEF_CALLBACK
translator_test_set_own_ptr_library_and_return(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_library_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: val; type: ownptr_same
  DCHECK(val);
  if (!val) {
    return NULL;
  }

  // Execute
  CefOwnPtr<CefTranslatorTestScopedLibrary> _retval =
      CefTranslatorTestCppToC::Get(self)->SetOwnPtrLibraryAndReturn(
          CefTranslatorTestScopedLibraryCppToC::UnwrapOwn(val));

  // Return type: ownptr_same
  return CefTranslatorTestScopedLibraryCppToC::WrapOwn(std::move(_retval));
}

int CEF_CALLBACK translator_test_set_child_own_ptr_library(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_library_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: ownptr_same
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->SetChildOwnPtrLibrary(
      CefTranslatorTestScopedLibraryChildCppToC::UnwrapOwn(val));

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_scoped_library_t* CEF_CALLBACK
translator_test_set_child_own_ptr_library_and_return_parent(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_library_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: val; type: ownptr_same
  DCHECK(val);
  if (!val) {
    return NULL;
  }

  // Execute
  CefOwnPtr<CefTranslatorTestScopedLibrary> _retval =
      CefTranslatorTestCppToC::Get(self)->SetChildOwnPtrLibraryAndReturnParent(
          CefTranslatorTestScopedLibraryChildCppToC::UnwrapOwn(val));

  // Return type: ownptr_same
  return CefTranslatorTestScopedLibraryCppToC::WrapOwn(std::move(_retval));
}

int CEF_CALLBACK translator_test_set_own_ptr_client(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_client_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: ownptr_diff
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: ownptr_diff
  CefOwnPtr<CefTranslatorTestScopedClient> valPtr(
      CefTranslatorTestScopedClientCToCpp::Wrap(val));

  // Execute
  int _retval =
      CefTranslatorTestCppToC::Get(self)->SetOwnPtrClient(std::move(valPtr));

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_scoped_client_t* CEF_CALLBACK
translator_test_set_own_ptr_client_and_return(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_client_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: val; type: ownptr_diff
  DCHECK(val);
  if (!val) {
    return NULL;
  }

  // Translate param: val; type: ownptr_diff
  CefOwnPtr<CefTranslatorTestScopedClient> valPtr(
      CefTranslatorTestScopedClientCToCpp::Wrap(val));

  // Execute
  CefOwnPtr<CefTranslatorTestScopedClient> _retval =
      CefTranslatorTestCppToC::Get(self)->SetOwnPtrClientAndReturn(
          std::move(valPtr));

  // Return type: ownptr_diff
  return CefTranslatorTestScopedClientCToCpp::UnwrapOwn(std::move(_retval));
}

int CEF_CALLBACK translator_test_set_child_own_ptr_client(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_client_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: ownptr_diff
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: ownptr_diff
  CefOwnPtr<CefTranslatorTestScopedClientChild> valPtr(
      CefTranslatorTestScopedClientChildCToCpp::Wrap(val));

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->SetChildOwnPtrClient(
      std::move(valPtr));

  // Return type: simple
  return _retval;
}

struct _cef_translator_test_scoped_client_t* CEF_CALLBACK
translator_test_set_child_own_ptr_client_and_return_parent(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_client_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: val; type: ownptr_diff
  DCHECK(val);
  if (!val) {
    return NULL;
  }

  // Translate param: val; type: ownptr_diff
  CefOwnPtr<CefTranslatorTestScopedClientChild> valPtr(
      CefTranslatorTestScopedClientChildCToCpp::Wrap(val));

  // Execute
  CefOwnPtr<CefTranslatorTestScopedClient> _retval =
      CefTranslatorTestCppToC::Get(self)->SetChildOwnPtrClientAndReturnParent(
          std::move(valPtr));

  // Return type: ownptr_diff
  return CefTranslatorTestScopedClientCToCpp::UnwrapOwn(std::move(_retval));
}

int CEF_CALLBACK translator_test_set_raw_ptr_library(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_library_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: rawptr_same
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->SetRawPtrLibrary(
      CefTranslatorTestScopedLibraryCppToC::UnwrapRaw(val));

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK translator_test_set_child_raw_ptr_library(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_library_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: rawptr_same
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = CefTranslatorTestCppToC::Get(self)->SetChildRawPtrLibrary(
      CefTranslatorTestScopedLibraryChildCppToC::UnwrapRaw(val));

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK translator_test_set_raw_ptr_library_list(
    struct _cef_translator_test_t* self,
    size_t valCount,
    struct _cef_translator_test_scoped_library_t* const* val,
    int val1,
    int val2) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: rawptr_vec_same_byref_const
  DCHECK(valCount == 0 || val);
  if (valCount > 0 && !val) {
    return 0;
  }

  // Translate param: val; type: rawptr_vec_same_byref_const
  std::vector<CefRawPtr<CefTranslatorTestScopedLibrary>> valList;
  if (valCount > 0) {
    for (size_t i = 0; i < valCount; ++i) {
      CefRawPtr<CefTranslatorTestScopedLibrary> valVal =
          CefTranslatorTestScopedLibraryCppToC::UnwrapRaw(val[i]);
      valList.push_back(valVal);
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetRawPtrLibraryList(
      valList, val1, val2);

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK translator_test_set_raw_ptr_client(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_client_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: rawptr_diff
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: rawptr_diff
  CefOwnPtr<CefTranslatorTestScopedClient> valPtr(
      CefTranslatorTestScopedClientCToCpp::Wrap(val));

  // Execute
  int _retval =
      CefTranslatorTestCppToC::Get(self)->SetRawPtrClient(valPtr.get());

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK translator_test_set_child_raw_ptr_client(
    struct _cef_translator_test_t* self,
    struct _cef_translator_test_scoped_client_child_t* val) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: rawptr_diff
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: rawptr_diff
  CefOwnPtr<CefTranslatorTestScopedClientChild> valPtr(
      CefTranslatorTestScopedClientChildCToCpp::Wrap(val));

  // Execute
  int _retval =
      CefTranslatorTestCppToC::Get(self)->SetChildRawPtrClient(valPtr.get());

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK translator_test_set_raw_ptr_client_list(
    struct _cef_translator_test_t* self,
    size_t valCount,
    struct _cef_translator_test_scoped_client_t* const* val,
    int val1,
    int val2) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: val; type: rawptr_vec_diff_byref_const
  DCHECK(valCount == 0 || val);
  if (valCount > 0 && !val) {
    return 0;
  }

  // Translate param: val; type: rawptr_vec_diff_byref_const
  std::vector<CefRawPtr<CefTranslatorTestScopedClient>> valList;
  if (valCount > 0) {
    for (size_t i = 0; i < valCount; ++i) {
      CefRawPtr<CefTranslatorTestScopedClient> valVal =
          CefTranslatorTestScopedClientCToCpp::Wrap(val[i]).release();
      valList.push_back(valVal);
    }
  }

  // Execute
  bool _retval = CefTranslatorTestCppToC::Get(self)->SetRawPtrClientList(
      valList, val1, val2);

  // Restore param: val; type: rawptr_vec_diff_byref_const
  if (valCount > 0) {
    for (size_t i = 0; i < valCount; ++i) {
      delete valList[i];
    }
  }

  // Return type: bool
  return _retval;
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefTranslatorTestCppToC::CefTranslatorTestCppToC() {
  GetStruct()->get_void = translator_test_get_void;
  GetStruct()->get_bool = translator_test_get_bool;
  GetStruct()->get_int = translator_test_get_int;
  GetStruct()->get_double = translator_test_get_double;
  GetStruct()->get_long = translator_test_get_long;
  GetStruct()->get_sizet = translator_test_get_sizet;
  GetStruct()->set_void = translator_test_set_void;
  GetStruct()->set_bool = translator_test_set_bool;
  GetStruct()->set_int = translator_test_set_int;
  GetStruct()->set_double = translator_test_set_double;
  GetStruct()->set_long = translator_test_set_long;
  GetStruct()->set_sizet = translator_test_set_sizet;
  GetStruct()->set_int_list = translator_test_set_int_list;
  GetStruct()->get_int_list_by_ref = translator_test_get_int_list_by_ref;
  GetStruct()->get_int_list_size = translator_test_get_int_list_size;
  GetStruct()->get_string = translator_test_get_string;
  GetStruct()->set_string = translator_test_set_string;
  GetStruct()->get_string_by_ref = translator_test_get_string_by_ref;
  GetStruct()->set_string_list = translator_test_set_string_list;
  GetStruct()->get_string_list_by_ref = translator_test_get_string_list_by_ref;
  GetStruct()->set_string_map = translator_test_set_string_map;
  GetStruct()->get_string_map_by_ref = translator_test_get_string_map_by_ref;
  GetStruct()->set_string_multimap = translator_test_set_string_multimap;
  GetStruct()->get_string_multimap_by_ref =
      translator_test_get_string_multimap_by_ref;
  GetStruct()->get_point = translator_test_get_point;
  GetStruct()->set_point = translator_test_set_point;
  GetStruct()->get_point_by_ref = translator_test_get_point_by_ref;
  GetStruct()->set_point_list = translator_test_set_point_list;
  GetStruct()->get_point_list_by_ref = translator_test_get_point_list_by_ref;
  GetStruct()->get_point_list_size = translator_test_get_point_list_size;
  GetStruct()->get_ref_ptr_library = translator_test_get_ref_ptr_library;
  GetStruct()->set_ref_ptr_library = translator_test_set_ref_ptr_library;
  GetStruct()->set_ref_ptr_library_and_return =
      translator_test_set_ref_ptr_library_and_return;
  GetStruct()->set_child_ref_ptr_library =
      translator_test_set_child_ref_ptr_library;
  GetStruct()->set_child_ref_ptr_library_and_return_parent =
      translator_test_set_child_ref_ptr_library_and_return_parent;
  GetStruct()->set_ref_ptr_library_list =
      translator_test_set_ref_ptr_library_list;
  GetStruct()->get_ref_ptr_library_list_by_ref =
      translator_test_get_ref_ptr_library_list_by_ref;
  GetStruct()->get_ref_ptr_library_list_size =
      translator_test_get_ref_ptr_library_list_size;
  GetStruct()->set_ref_ptr_client = translator_test_set_ref_ptr_client;
  GetStruct()->set_ref_ptr_client_and_return =
      translator_test_set_ref_ptr_client_and_return;
  GetStruct()->set_child_ref_ptr_client =
      translator_test_set_child_ref_ptr_client;
  GetStruct()->set_child_ref_ptr_client_and_return_parent =
      translator_test_set_child_ref_ptr_client_and_return_parent;
  GetStruct()->set_ref_ptr_client_list =
      translator_test_set_ref_ptr_client_list;
  GetStruct()->get_ref_ptr_client_list_by_ref =
      translator_test_get_ref_ptr_client_list_by_ref;
  GetStruct()->get_ref_ptr_client_list_size =
      translator_test_get_ref_ptr_client_list_size;
  GetStruct()->get_own_ptr_library = translator_test_get_own_ptr_library;
  GetStruct()->set_own_ptr_library = translator_test_set_own_ptr_library;
  GetStruct()->set_own_ptr_library_and_return =
      translator_test_set_own_ptr_library_and_return;
  GetStruct()->set_child_own_ptr_library =
      translator_test_set_child_own_ptr_library;
  GetStruct()->set_child_own_ptr_library_and_return_parent =
      translator_test_set_child_own_ptr_library_and_return_parent;
  GetStruct()->set_own_ptr_client = translator_test_set_own_ptr_client;
  GetStruct()->set_own_ptr_client_and_return =
      translator_test_set_own_ptr_client_and_return;
  GetStruct()->set_child_own_ptr_client =
      translator_test_set_child_own_ptr_client;
  GetStruct()->set_child_own_ptr_client_and_return_parent =
      translator_test_set_child_own_ptr_client_and_return_parent;
  GetStruct()->set_raw_ptr_library = translator_test_set_raw_ptr_library;
  GetStruct()->set_child_raw_ptr_library =
      translator_test_set_child_raw_ptr_library;
  GetStruct()->set_raw_ptr_library_list =
      translator_test_set_raw_ptr_library_list;
  GetStruct()->set_raw_ptr_client = translator_test_set_raw_ptr_client;
  GetStruct()->set_child_raw_ptr_client =
      translator_test_set_child_raw_ptr_client;
  GetStruct()->set_raw_ptr_client_list =
      translator_test_set_raw_ptr_client_list;
}

// DESTRUCTOR - Do not edit by hand.

CefTranslatorTestCppToC::~CefTranslatorTestCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefTranslatorTest> CefCppToCRefCounted<
    CefTranslatorTestCppToC,
    CefTranslatorTest,
    cef_translator_test_t>::UnwrapDerived(CefWrapperType type,
                                          cef_translator_test_t* s) {
  NOTREACHED() << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefTranslatorTestCppToC,
                                   CefTranslatorTest,
                                   cef_translator_test_t>::kWrapperType =
    WT_TRANSLATOR_TEST;
