// Copyright (c) 2023 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=117fcfcb178f8a8a08272186c250c4042fcd74c0$
//

#include "libcef_dll/cpptoc/media_route_cpptoc.h"
#include "libcef_dll/cpptoc/media_sink_cpptoc.h"
#include "libcef_dll/cpptoc/media_source_cpptoc.h"
#include "libcef_dll/shutdown_checker.h"

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

cef_string_userfree_t CEF_CALLBACK
media_route_get_id(struct _cef_media_route_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefMediaRouteCppToC::Get(self)->GetId();

  // Return type: string
  return _retval.DetachToUserFree();
}

struct _cef_media_source_t* CEF_CALLBACK
media_route_get_source(struct _cef_media_route_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefMediaSource> _retval =
      CefMediaRouteCppToC::Get(self)->GetSource();

  // Return type: refptr_same
  return CefMediaSourceCppToC::Wrap(_retval);
}

struct _cef_media_sink_t* CEF_CALLBACK
media_route_get_sink(struct _cef_media_route_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefMediaSink> _retval = CefMediaRouteCppToC::Get(self)->GetSink();

  // Return type: refptr_same
  return CefMediaSinkCppToC::Wrap(_retval);
}

void CEF_CALLBACK
media_route_send_route_message(struct _cef_media_route_t* self,
                               const void* message,
                               size_t message_size) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: message; type: simple_byaddr
  DCHECK(message);
  if (!message) {
    return;
  }

  // Execute
  CefMediaRouteCppToC::Get(self)->SendRouteMessage(message, message_size);
}

void CEF_CALLBACK media_route_terminate(struct _cef_media_route_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefMediaRouteCppToC::Get(self)->Terminate();
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefMediaRouteCppToC::CefMediaRouteCppToC() {
  GetStruct()->get_id = media_route_get_id;
  GetStruct()->get_source = media_route_get_source;
  GetStruct()->get_sink = media_route_get_sink;
  GetStruct()->send_route_message = media_route_send_route_message;
  GetStruct()->terminate = media_route_terminate;
}

// DESTRUCTOR - Do not edit by hand.

CefMediaRouteCppToC::~CefMediaRouteCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefMediaRoute>
CefCppToCRefCounted<CefMediaRouteCppToC, CefMediaRoute, cef_media_route_t>::
    UnwrapDerived(CefWrapperType type, cef_media_route_t* s) {
  NOTREACHED() << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefMediaRouteCppToC,
                                   CefMediaRoute,
                                   cef_media_route_t>::kWrapperType =
    WT_MEDIA_ROUTE;
