#ifndef direction3_H
#define direction3_H


static const char* direction3[] = {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>",
"<schema targetNamespace=\"http://www.opengis.net/gml\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns=\"http://www.w3.org/2001/XMLSchema\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" elementFormDefault=\"qualified\"",
"        version=\"3.1.1\">",
"	<annotation>",
"		<appinfo source=\"urn:opengis:specification:gml:schema-xsd:direction:3.1.1\">direction.xsd</appinfo>",
"		<documentation>This schema defines \"direction\" element and type.",
"    Copyright (c) 2002-2005 OGC, All Rights Reserved.",
"	For conditions, see OGC Software Notice http://www.opengeospatial.org/about/?page=ipr</documentation>",
"	</annotation>",
"	<!-- ==============================================================",
"       includes and imports",
"	============================================================== -->",
"	<include schemaLocation=\"geometryBasic0d1d.xsd\"/>",
"	<!-- ============================================================== -->",
"	<!--===================================================================  -->",
"	<element name=\"direction\" type=\"gml:DirectionPropertyType\"/>",
"	<!--===================================================================  -->",
"	<complexType name=\"DirectionPropertyType\">",
"		<annotation>",
"			<documentation/>",
"		</annotation>",
"		<choice>",
"			<element ref=\"gml:DirectionVector\"/>",
"			<element ref=\"gml:CompassPoint\"/>",
"			<element name=\"DirectionKeyword\" type=\"gml:CodeType\"/>",
"			<element name=\"DirectionString\" type=\"gml:StringOrRefType\"/>",
"		</choice>",
"		<attributeGroup ref=\"gml:AssociationAttributeGroup\"/>",
"	</complexType>",
"	<!--===================================================================  -->",
"	<element name=\"DirectionVector\" type=\"gml:DirectionVectorType\"/>",
"	<!--===================================================================  -->",
"	<complexType name=\"DirectionVectorType\">",
"		<annotation>",
"			<documentation>Direction expressed as a vector, either using components, or using angles.</documentation>",
"		</annotation>",
"		<choice>",
"			<element ref=\"gml:vector\"/>",
"			<sequence>",
"				<element name=\"horizontalAngle\" type=\"gml:AngleType\"/>",
"				<element name=\"verticalAngle\" type=\"gml:AngleType\"/>",
"			</sequence>",
"		</choice>",
"	</complexType>",
"	<!--===================================================================  -->",
"	<element name=\"CompassPoint\" type=\"gml:CompassPointEnumeration\"/>",
"	<!--===================================================================  -->",
"	<simpleType name=\"CompassPointEnumeration\">",
"		<restriction base=\"string\">",
"			<enumeration value=\"N\"/>",
"			<enumeration value=\"NNE\"/>",
"			<enumeration value=\"NE\"/>",
"			<enumeration value=\"ENE\"/>",
"			<enumeration value=\"E\"/>",
"			<enumeration value=\"ESE\"/>",
"			<enumeration value=\"SE\"/>",
"			<enumeration value=\"SSE\"/>",
"			<enumeration value=\"S\"/>",
"			<enumeration value=\"SSW\"/>",
"			<enumeration value=\"SW\"/>",
"			<enumeration value=\"WSW\"/>",
"			<enumeration value=\"W\"/>",
"			<enumeration value=\"WNW\"/>",
"			<enumeration value=\"NW\"/>",
"			<enumeration value=\"NNW\"/>",
"		</restriction>",
"	</simpleType>",
"	<!--===================================================================  -->",
"</schema>",
NULL
};

#endif
