#ifndef dictionary3_H
#define dictionary3_H

 //
 // Copyright (C) 2004-2010  Autodesk, Inc.
 // 
 // This library is free software; you can redistribute it and/or
 // modify it under the terms of version 2.1 of the GNU Lesser
 // General Public License as published by the Free Software Foundation.
 // 
 // This library is distributed in the hope that it will be useful,
 // but WITHOUT ANY WARRANTY; without even the implied warranty of
 // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 // Lesser General Public License for more details.
 // 
 // You should have received a copy of the GNU Lesser General Public
 // License along with this library; if not, write to the Free Software
 // Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

static const char* dictionary3[] = {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>",
"<schema targetNamespace=\"http://www.opengis.net/gml\" elementFormDefault=\"qualified\" version=\"3.1.1\" xmlns=\"http://www.w3.org/2001/XMLSchema\" xmlns:gml=\"http://www.opengis.net/gml\">",
"	<annotation>",
"		<appinfo source=\"urn:opengis:specification:gml:schema-xsd:dictionary:3.1.1\"/>",
"		<documentation>",
"			Dictionary schema for GML 3.1.1 ",
"			Components to support the lists of definitions.  ",
"    Copyright (c) 2005 OGC, All Rights Reserved.",
"	For conditions, see OGC Software Notice http://www.opengeospatial.org/about/?page=ipr</documentation>",
"	</annotation>",
"	<!-- ========================================================",
"       includes and imports",
"	======================================================== -->",
"	<include schemaLocation=\"gmlBase.xsd\"/>",
"	<!-- ===================================================== -->",
"	<!-- ===================================================== -->",
"	<!-- === Dictionary and Definition components === -->",
"	<!-- ===================================================== -->",
"	<group name=\"StandardDefinitionProperties\">",
"		<annotation>",
"			<documentation>This content model group makes it easier to construct types that ",
"      derive from DefinitionType and its descendents \"by restriction\".  ",
"      A reference to the group saves having to enumerate the standard definition properties. ",
"      See definition of StandardObjectProperties for more documentation</documentation>",
"		</annotation>",
"		<sequence>",
"			<element ref=\"gml:metaDataProperty\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>",
"			<element ref=\"gml:description\" minOccurs=\"0\"/>",
"			<element ref=\"gml:name\" maxOccurs=\"unbounded\"/>",
"		</sequence>",
"	</group>",
"	<!-- ===================================================== -->",
"	<element name=\"Definition\" type=\"gml:DefinitionType\" substitutionGroup=\"gml:_GML\"/>",
"	<!-- ===================================================== -->",
"	<complexType name=\"DefinitionType\">",
"		<annotation>",
"			<documentation>A definition, which can be included in or referenced by a dictionary. In this extended type, the inherited \"description\" optional element can hold the definition whenever only text is needed. The inherited \"name\" elements can provide one or more brief terms for which this is the definition. The inherited \"metaDataProperty\" elements can be used to reference or include more information about this definition.  ",
"The gml:id attribute is required - it must be possible to reference this definition using this handle.  </documentation>",
"		</annotation>",
"		<complexContent>",
"			<restriction base=\"gml:AbstractGMLType\">",
"				<sequence>",
"					<element ref=\"gml:metaDataProperty\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>",
"					<element ref=\"gml:description\" minOccurs=\"0\"/>",
"					<element ref=\"gml:name\" maxOccurs=\"unbounded\"/>",
"				</sequence>",
"				<attribute ref=\"gml:id\" use=\"required\"/>",
"			</restriction>",
"		</complexContent>",
"	</complexType>",
"	<!-- ===================================================== -->",
"	<element name=\"Dictionary\" type=\"gml:DictionaryType\" substitutionGroup=\"gml:Definition\"/>",
"	<element name=\"DefinitionCollection\" type=\"gml:DictionaryType\" substitutionGroup=\"gml:Definition\"/>",
"	<!-- ===================================================== -->",
"	<complexType name=\"DictionaryType\">",
"		<annotation>",
"			<documentation>A non-abstract bag that is specialized for use as a dictionary which contains a set of definitions. These definitions are referenced from other places, in the same and different XML documents. In this restricted type, the inherited optional \"description\" element can be used for a description of this dictionary. The inherited optional \"name\" element can be used for the name(s) of this dictionary. The inherited \"metaDataProperty\" elements can be used to reference or contain more information about this dictionary. The inherited required gml:id attribute allows the dictionary to be referenced using this handle. </documentation>",
"		</annotation>",
"		<complexContent>",
"			<extension base=\"gml:DefinitionType\">",
"				<sequence minOccurs=\"0\" maxOccurs=\"unbounded\">",
"					<choice>",
"						<element ref=\"gml:dictionaryEntry\">",
"							<annotation>",
"								<documentation>An entry in this dictionary. The content of an entry can itself be a lower level dictionary or definition collection. This element follows the standard GML property model, so the value may be provided directly or by reference. Note that if the value is provided by reference, this definition does not carry a handle (gml:id) in this context, so does not allow external references to this specific entry in this context. When used in this way the referenced definition will usually be in a dictionary in the same XML document. </documentation>",
"							</annotation>",
"						</element>",
"						<element ref=\"gml:indirectEntry\">",
"							<annotation>",
"								<documentation>An identified reference to a remote entry in this dictionary, to be used when this entry should be identified to allow external references to this specific entry. </documentation>",
"							</annotation>",
"						</element>",
"					</choice>",
"				</sequence>",
"			</extension>",
"		</complexContent>",
"	</complexType>",
"	<!-- ===================================================== -->",
"	<element name=\"dictionaryEntry\" type=\"gml:DictionaryEntryType\"/>",
"	<element name=\"definitionMember\" type=\"gml:DictionaryEntryType\" substitutionGroup=\"gml:dictionaryEntry\"/>",
"	<!-- ===================================================== -->",
"	<complexType name=\"DictionaryEntryType\">",
"		<annotation>",
"			<documentation>An entry in a dictionary of definitions. An instance of this type contains or refers to a definition object.  ",
"",
"The number of definitions contained in this dictionaryEntry is restricted to one, but a DefinitionCollection or Dictionary that contains multiple definitions can be substituted if needed. Specialized descendents of this dictionaryEntry might be restricted in an application schema to allow only including specified types of definitions as valid entries in a dictionary. </documentation>",
"		</annotation>",
"		<sequence minOccurs=\"0\">",
"			<element ref=\"gml:Definition\">",
"				<annotation>",
"					<documentation>This element in a dictionary entry contains the actual definition. </documentation>",
"				</annotation>",
"			</element>",
"		</sequence>",
"		<attributeGroup ref=\"gml:AssociationAttributeGroup\">",
"			<annotation>",
"				<documentation>A non-identified reference to a remote entry in this dictionary, to be used when this entry need not be identified to allow external references to this specific entry. The remote entry referenced will usually be in a dictionary in the same XML document. This element will usually be used in dictionaries that are inside of another dictionary. </documentation>",
"			</annotation>",
"		</attributeGroup>",
"	</complexType>",
"	<!-- ===================================================== -->",
"	<element name=\"indirectEntry\" type=\"gml:IndirectEntryType\"/>",
"	<!-- ===================================================== -->",
"	<complexType name=\"IndirectEntryType\">",
"		<annotation>",
"			<documentation>An entry in a dictionary of definitions that contains a GML object which references a remote definition object. This entry is expected to be convenient in allowing multiple elements in one XML document to contain short (abbreviated XPointer) references, which are resolved to an external definition provided in a Dictionary element in the same XML document. Specialized descendents of this dictionaryEntry might be restricted in an application schema to allow only including specified types of definitions as valid entries in a dictionary. </documentation>",
"		</annotation>",
"		<sequence>",
"			<element ref=\"gml:DefinitionProxy\"/>",
"		</sequence>",
"	</complexType>",
"	<!-- ===================================================== -->",
"	<element name=\"DefinitionProxy\" type=\"gml:DefinitionProxyType\" substitutionGroup=\"gml:Definition\"/>",
"	<!-- ===================================================== -->",
"	<complexType name=\"DefinitionProxyType\">",
"		<annotation>",
"			<documentation>A proxy entry in a dictionary of definitions. An element of this type contains a reference to a remote definition object. This entry is expected to be convenient in allowing multiple elements in one XML document to contain short (abbreviated XPointer) references, which are resolved to an external definition provided in a Dictionary element in the same XML document. </documentation>",
"		</annotation>",
"		<complexContent>",
"			<extension base=\"gml:DefinitionType\">",
"				<sequence>",
"					<element ref=\"gml:definitionRef\">",
"						<annotation>",
"							<documentation>A reference to a remote entry in this dictionary, used when this dictionary entry is identified to allow external references to this specific entry. The remote entry referenced can be in a dictionary in the same or different XML document. </documentation>",
"						</annotation>",
"					</element>",
"				</sequence>",
"			</extension>",
"		</complexContent>",
"	</complexType>",
"	<!-- ===================================================== -->",
"	<element name=\"definitionRef\" type=\"gml:ReferenceType\"/>",
"	<!-- =========================================================== -->",
"</schema>",
NULL
};

#endif
