/*
* Copyright (C) 2006  Haris Kurtagic
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of version 2.1 of the GNU Lesser
* General Public License as published by the Free Software Foundation.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "stdafx.h"

c_KgMssSchemaCapabilities::c_KgMssSchemaCapabilities ()
{
}

c_KgMssSchemaCapabilities::~c_KgMssSchemaCapabilities ()
{
}

void c_KgMssSchemaCapabilities::Dispose ()
{
    delete this;
}

/// <summary>Returns an array of the FdoClassType objects the feature provider supports.</summary>
/// <param name="length">Output the number of class types.</param> 
/// <returns>Returns the list of class types.</returns> 
FdoClassType* c_KgMssSchemaCapabilities::GetClassTypes (FdoInt32& Length)
{
    static FdoClassType classes[] =
    {
        FdoClassType_FeatureClass,
        FdoClassType_Class
    };

    Length = sizeof (classes) / sizeof (FdoClassType);

    return (classes);
}//end of c_KgMssSchemaCapabilities::GetClassTypes

/// <summary>Returns an array of the FdoDataType objects the feature provider supports.</summary>
/// <param name="length">Output the number of data types.</param> 
/// <returns>Returns the list of data types</returns> 
FdoDataType* c_KgMssSchemaCapabilities::GetDataTypes (FdoInt32& Length)
{
    static FdoDataType types[] =
    {
        FdoDataType_Boolean,
        FdoDataType_Byte,
        FdoDataType_DateTime,
        FdoDataType_Decimal,
        FdoDataType_Double,
        FdoDataType_Int16,
        FdoDataType_Int32,
        FdoDataType_Int64,
        FdoDataType_Single,
        FdoDataType_String,
    };

    Length = sizeof (types) / sizeof (FdoDataType);

    return (types);
}//end of c_KgMssSchemaCapabilities::GetDataTypes


/// <summary>Determines if the feature provider supports inheritance.</summary>
/// <returns>Returns true if the feature provider supports inheritance</returns> 
bool c_KgMssSchemaCapabilities::SupportsInheritance ()
{
    return false;
}


/// <summary>Determines if the provider supports multiple schemas. Returns false if the provider supports only a single schema.</summary>
/// <returns>Returns true if the provider supports multiple schemas.</returns> 
bool c_KgMssSchemaCapabilities::SupportsMultipleSchemas ()
{
    return true;
}


/// <summary>Determines if the provider supports object properties. Returns false if the provider supports only data and geometric properties.</summary>
/// <returns>Returns true if the provider supports object properties.</returns> 
bool c_KgMssSchemaCapabilities::SupportsObjectProperties ()
{
    return false;
}


/// <summary>Determines if the provider supports Schema Mapping Overrides 
/// (overrides to the default rules for mapping Feature Schemas to provider-specific
/// physical schemas)</summary>
/// <returns>Returns true if the provider supports Schema Overrides</returns> 
bool c_KgMssSchemaCapabilities::SupportsSchemaOverrides ()
{
    return true;
}


/// <summary>Determines if the provider supports association property.</summary>
/// <returns>Returns true if the provider support the association property.</returns> 
bool c_KgMssSchemaCapabilities::SupportsAssociationProperties (void)
{
    return false;
}

/// <summary>Determines if the provider supports the network model.</summary>
/// <returns>Returns true if the provider supports the network model.</returns> 
bool c_KgMssSchemaCapabilities::SupportsNetworkModel (void)
{
    return false;
}

/// <summary>Determines if the provider can auto-generate unique ID values for a class.</summary>
/// <returns>Returns true if the provider supports id autogeneration.</returns> 
bool c_KgMssSchemaCapabilities::SupportsAutoIdGeneration ()
{
    return true;
}

/// <summary>Determines if the provider can auto-generate unique ID values that are unique for the entire datastore, rather than just for a particular class.</summary>
/// <returns>Returns true if the provider supports id autogeneration unique across an datastore.</returns> 
bool c_KgMssSchemaCapabilities::SupportsDataStoreScopeUniqueIdGeneration ()
{
    return false;
}

/// <summary>Returns an array of the FdoDataType objects the feature provider supports for auto-generation.</summary>
/// <param name="length">Output the number of data types.</param> 
/// <returns>Returns the list of data types</returns> 
FdoDataType* c_KgMssSchemaCapabilities::GetSupportedAutoGeneratedTypes (FdoInt32& Length)
{
    static FdoDataType autogen_types[] =
    {
        FdoDataType_Int32,
    };

    Length = sizeof (autogen_types) / sizeof (FdoDataType);

    return (autogen_types);
}

/// <summary>Determines if the provider support update a schema through the ApplySchema command.
/// If False, then an application can only create a schema once for the provider.
/// They can use the ApplySchema command once for a given datastore.
/// Once the schema is defined, it cannot be changed.
/// If True, then the provider supports the ability to modify or add to the schema after it is defined initially.</summary>
/// <returns>Returns true if the provider supports the update of the schema.</returns>
bool c_KgMssSchemaCapabilities::SupportsSchemaModification ()
{
    return true;
}

/// <summary>Determines if the provider supports inclusive value range constraints.</summary>
/// <returns>Returns true if the provider supports inclusive value range constraints.</returns> 
bool c_KgMssSchemaCapabilities::SupportsInclusiveValueRangeConstraints()
{
    return false;
}

/// <summary>Determines if the provider supports exclusive value range constraints.</summary>
/// <returns>Returns true if the provider supports exclusive value range constraints.</returns>
bool c_KgMssSchemaCapabilities::SupportsExclusiveValueRangeConstraints()
{
    return false;
}
/// <summary>Determines if the provider supports value constraints list.</summary>
/// <returns>Returns true if the provider supports value constraints list.</returns>
bool c_KgMssSchemaCapabilities::SupportsValueConstraintsList()
{
    return false;
}

/// <summary>Determines if the provider supports nullable value constraint.</summary>
/// <returns>Returns true if the provider supports nullable value constraint.</returns>
bool c_KgMssSchemaCapabilities::SupportsNullValueConstraints()
{
    return true;
}

/// <summary>Determines if the provider supports unique value constraint.</summary>
/// <returns>Returns true if the provider supports unique value constraint.</returns>
bool c_KgMssSchemaCapabilities::SupportsUniqueValueConstraints()
{
    return false;
}

/// <summary>Determines if the provider supports composite unique value constraint.</summary>
/// <returns>Returns true if the provider supports composite unique value constraint.</returns>
bool c_KgMssSchemaCapabilities::SupportsCompositeUniqueValueConstraints()
{
    return false;
}

/// <summary>Determines if the provider supports multiple identity properties per class.</summary>
/// <returns>Returns true if the provider supports multiple identity properties per class.</returns>
bool c_KgMssSchemaCapabilities::SupportsCompositeId()
{
    return false;
}

#ifdef _FDO_3_2

/// \brief
/// Returns the maximum supported length of String, BLOB, or CLOB data
/// properties. For decimal, it is typically the combination of the maximum
/// scale and precision. For other data types that are not variable in size,
/// the value returned is the byte length.
///
/// \param dataType
/// The data type for which the information is to retrieved.
///
/// \return
/// Returns the maximum data value length for the identified data type.
///
FdoInt64 c_KgMssSchemaCapabilities::GetMaximumDataValueLength(FdoDataType DataType)
{
   switch (DataType)
    {
        case FdoDataType_String:   return (FdoInt64)-1;
        case FdoDataType_BLOB:     return (FdoInt64)-1;
        case FdoDataType_CLOB:     return (FdoInt64)-1;
        case FdoDataType_Decimal:  return (FdoInt64)-1;
        case FdoDataType_Boolean:  return (FdoInt64)sizeof(FdoBoolean);
        case FdoDataType_Byte:     return (FdoInt64)sizeof(FdoByte);
        case FdoDataType_DateTime: return (FdoInt64)sizeof(FdoDateTime);
        case FdoDataType_Double:   return (FdoInt64)sizeof(FdoDouble);
        case FdoDataType_Int16:    return (FdoInt64)sizeof(FdoInt16);
        case FdoDataType_Int32:    return (FdoInt64)sizeof(FdoInt32);
        case FdoDataType_Int64:    return (FdoInt64)sizeof(FdoInt64);
        case FdoDataType_Single:   return (FdoInt64)sizeof(FdoFloat);
    }
    return (FdoInt64)-1;
}

/// \brief
/// Returns the maximum supported precision for a decimal data property.
///
/// \param
/// None.
///
/// \return
/// Returns the maximum supported precision for a decimal data property.
///
FdoInt32 c_KgMssSchemaCapabilities::GetMaximumDecimalPrecision()
{
  return -1;
}

/// \brief
/// Returns the maximum supported scale for a decimal data property.
///
/// \param
/// None.
///
/// \return
/// Returns the maximum supported scale for a decimal data property.
///
FdoInt32 c_KgMssSchemaCapabilities::GetMaximumDecimalScale()
{
  return -1;
}

/// \brief
/// Returns the maximum size of a value of the given type. It includes
/// limits for the data store name, shema name, class name, property name
/// and description.
///
/// \param name
/// The schema element name type identifier for which the information is to
/// be retrieved. Can be any of the following options: FdoSchemaElementNameType_Datastore,
/// FdoSchemaElementNameType_Schema, FdoSchemaElementNameType_Class, FdoSchemaElementNameType_Property or 
/// FdoSchemaElementNameType_Description
///
/// \return
/// Returns the size limitation for the identified schema element.
///
FDOKGMSS_API FdoInt32 c_KgMssSchemaCapabilities::GetNameSizeLimit(FdoSchemaElementNameType NameType)
{
   switch (NameType)
    {
        case FdoSchemaElementNameType_Datastore:   return 30;  // the max filename length on linux/windows
        case FdoSchemaElementNameType_Schema:      return 30;
        case FdoSchemaElementNameType_Class:       return 30;
        case FdoSchemaElementNameType_Property:    return 30;
        case FdoSchemaElementNameType_Description: return -1;
    }
    return -1;
}

/// \brief
/// Returns a string that includes all the reserved characters that cannot be
/// used for the various schema element names for the provider.
///
/// \param
/// None
///
/// \return
/// Returns a string with the reserved characters for the identified schema element.
///
FDOKGMSS_API FdoString* c_KgMssSchemaCapabilities::GetReservedCharactersForName()
{
  return L"";
}

/// \brief
/// Returns a list of property types that can be used for identity properties.
///
/// \param length
/// Output the number of data types.
///
/// \return
/// Returns a string with the reserved characters for the identified schema element.
///
FdoDataType* c_KgMssSchemaCapabilities::GetSupportedIdentityPropertyTypes(FdoInt32& Length)
{
  Length = 0;
  static FdoDataType supportedIdentityTypes[15];
  supportedIdentityTypes[Length++] = FdoDataType_Boolean;
  supportedIdentityTypes[Length++] = FdoDataType_Byte;
  supportedIdentityTypes[Length++] = FdoDataType_DateTime;
  supportedIdentityTypes[Length++] = FdoDataType_Decimal;
  supportedIdentityTypes[Length++] = FdoDataType_Double;
  supportedIdentityTypes[Length++] = FdoDataType_Int16;
  supportedIdentityTypes[Length++] = FdoDataType_Int32;
  supportedIdentityTypes[Length++] = FdoDataType_Int64;
  supportedIdentityTypes[Length++] = FdoDataType_Single;
  supportedIdentityTypes[Length++] = FdoDataType_String;

  return supportedIdentityTypes;
}

/// \brief
/// Returns TRUE if default values can be specified for a data property
/// definition, FALSE otherwise.
///
/// \param
/// None
///
/// \return
/// Returns TRUE if default values can be specified for a data property
/// definition, FALSE otherwise.
///
bool c_KgMssSchemaCapabilities::SupportsDefaultValue()
{
  return false;
}

#endif    