/*! \mainpage Introduction
<div class="mainpage">
<!-- This is the index.html page that the user first sees. -->

<p>The Feature Data Objects (FDO) API provides access to data in a 
data store. A provider is a specific implementation of the FDO API 
that provides access to data in a particular data store. The FDO 
Provider for SQL Server provides FDO with access to a Microsoft SQL 
Server-based data store.
</p>

<p>SQL Server provides comprehensive data support, along with spatial indexing, 
optimistic concurrency, and read-committed transaction isolation. It uses a 
revision number for optimistic concurrency. 
</p>

<p>SQL Server authentication is supported for SQL Server data stores. The FDO 
User is mapped to the SQL Server login. Grant access to the databases
whose data you want to use.
</p>

<p>
A SQL Server schema can support the following:
</p>
<ul>
  <li>Inheritance
  <li>Multiple schemas
  <li>Object properties
  <li>Association properties
  <li>Schema overrrides
  <li>Auto ID generation
  <li>Inclusive value range constraints
  <li>Exclusive value range constraints
  <li>Value constraints list
  <li>Null value constraints
  <li>Unique value constraints
  <li>Composite unique value constraints
  <li>Spatial contexts
  <li>These geometry types: point, line string, polygon, multi-point, 
  multi-line string, multi-polygon, curve string, curve polygon, multi-curve 
  string, multi-curve polygon, linear ring, line string segment, circular arc 
  segment, and ring.
</ul>

<p>When you create a SQL Server schema, the following restrictions apply:
</p>
<ul>
  <li>A feature class must define or inherit at least one identity property.
  <li>You cannot specify default values for data properties.
  <li>Identity properties cannot be nullable.
  <li>Read-only identity properties must be autogenerated.
  <li>A feature class can have multiple geometric properties; main geometry is 
  not mandatory, but this attribute of the feature class indicates which geometry 
  property to use as the default for queries and rendering. HasMeasure and 
  HasElevation are supported. 
  <li>The maximum length of a string is 8000 characters.
</ul>

<p>For decimal properties, precision must be between 1 and 38 inclusive and 
scale must be between 0 and 38 inclusive.
</p>

<p>For more information, see <i>The Essential FDO</i> 
and the <i>FDO Developer's Guide</i>.
</p>

<br>
</div>
*/




