﻿#region XbimHeader

// The eXtensible Building Information Modelling (xBIM) Toolkit
// Solution:    XbimComplete
// Project:     Xbim.Ifc
// Filename:    IfcCurrencyEnum.cs
// Published:   01, 2012
// Last Edited: 9:04 AM on 20 12 2011
// (See accompanying copyright.rtf)

#endregion

namespace Xbim.Ifc2x3.MeasureResource
{
    /// <summary>
    ///   An enumeration of the international abbreviations of currencies used of various countries.
    /// </summary>
    public enum IfcCurrencyEnum
    {
        /// <summary>
        ///   United Arab Emirates
        /// </summary>
        AED,

        /// <summary>
        ///   Argentina
        /// </summary>
        AES,

        /// <summary>
        ///   Austria
        /// </summary>
        ATS,

        /// <summary>
        ///   Australia
        /// </summary>
        AUD,

        /// <summary>
        ///   Barbados
        /// </summary>
        BBD,

        /// <summary>
        ///   Belgium
        /// </summary>
        BEG,

        /// <summary>
        ///   Bulgaria
        /// </summary>
        BGL,

        /// <summary>
        ///   Bahrain
        /// </summary>
        BHD,

        /// <summary>
        ///   Bermuda
        /// </summary>
        BMD,

        /// <summary>
        ///   Brunei
        /// </summary>
        BND,

        /// <summary>
        ///   Brazil
        /// </summary>
        BRL,

        /// <summary>
        ///   Bahamas
        /// </summary>
        BSD,

        /// <summary>
        ///   Botswana
        /// </summary>
        BWP,

        /// <summary>
        ///   Belize
        /// </summary>
        BZD,

        /// <summary>
        ///   Canada
        /// </summary>
        CAD,

        /// <summary>
        ///   Carribean
        /// </summary>
        CBD,

        /// <summary>
        ///   Switzerland
        /// </summary>
        CHF,

        /// <summary>
        ///   Chile
        /// </summary>
        CLP,

        /// <summary>
        ///   China
        /// </summary>
        CNY,

        /// <summary>
        ///   Cyprus
        /// </summary>
        CYS,

        /// <summary>
        ///   Czech Republic
        /// </summary>
        CZK,

        /// <summary>
        ///   Dominican Republic
        /// </summary>
        DDP,

        /// <summary>
        ///   Germany
        /// </summary>
        DEM,

        /// <summary>
        ///   Denmark
        /// </summary>
        DKK,

        /// <summary>
        ///   Egypt
        /// </summary>
        EGL,

        /// <summary>
        ///   Spain
        /// </summary>
        EST,

        /// <summary>
        ///   currency adopted by a number of countries within the European Union from January 1st 1999. The zone in which the currency operates is termed 'Euroland' in financial transactions
        /// </summary>
        EUR,

        /// <summary>
        ///   Faroe Islands
        /// </summary>
        FAK,

        /// <summary>
        ///   Finland
        /// </summary>
        FIM,

        /// <summary>
        ///   Fiji
        /// </summary>
        FJD,

        /// <summary>
        ///   Falkland Islands
        /// </summary>
        FKP,

        /// <summary>
        ///   France
        /// </summary>
        FRF,

        /// <summary>
        ///   United Kingdom
        /// </summary>
        GBP,

        /// <summary>
        ///   Gibraltar
        /// </summary>
        GIP,

        /// <summary>
        ///   Gambia
        /// </summary>
        GMD,

        /// <summary>
        ///   Greece
        /// </summary>
        GRX,

        /// <summary>
        ///   Hong Kong
        /// </summary>
        HKD,

        /// <summary>
        ///   Hungary
        /// </summary>
        HUF,

        /// <summary>
        ///   Iceland
        /// </summary>
        ICK,

        /// <summary>
        ///   Indonesia
        /// </summary>
        IDR,

        /// <summary>
        ///   Israel
        /// </summary>
        ILS,

        /// <summary>
        ///   India
        /// </summary>
        INR,

        /// <summary>
        ///   Ireland
        /// </summary>
        IRP,

        /// <summary>
        ///   Italy
        /// </summary>
        ITL,

        /// <summary>
        ///   Jamaica
        /// </summary>
        JMD,

        /// <summary>
        ///   Jordan
        /// </summary>
        JOD,

        /// <summary>
        ///   Japan
        /// </summary>
        JPY,

        /// <summary>
        ///   Kenya
        /// </summary>
        KES,

        /// <summary>
        ///   Republic of Korea
        /// </summary>
        KRW,

        /// <summary>
        ///   Kuwait
        /// </summary>
        KWD,

        /// <summary>
        ///   Cayman Islands
        /// </summary>
        KYD,

        /// <summary>
        ///   Sri Lanka
        /// </summary>
        LKR,

        /// <summary>
        ///   Luxembourg
        /// </summary>
        LUF,

        /// <summary>
        ///   Malta
        /// </summary>
        MTL,

        /// <summary>
        ///   Mauritius
        /// </summary>
        MUR,

        /// <summary>
        ///   Mexico
        /// </summary>
        MXN,

        /// <summary>
        ///   Malaysia
        /// </summary>
        MYR,

        /// <summary>
        ///   Netherlands
        /// </summary>
        NLG,

        /// <summary>
        ///   New Zealand
        /// </summary>
        NZD,

        /// <summary>
        ///   Oman
        /// </summary>
        OMR,

        /// <summary>
        ///   Papua New Guinea
        /// </summary>
        PGK,

        /// <summary>
        ///   Philipines
        /// </summary>
        PHP,

        /// <summary>
        ///   Pakistan
        /// </summary>
        PKR,

        /// <summary>
        ///   Poland
        /// </summary>
        PLN,

        /// <summary>
        ///   Portugal
        /// </summary>
        PTN,

        /// <summary>
        ///   Qatar
        /// </summary>
        QAR,

        /// <summary>
        ///   Russia
        /// </summary>
        RUR,

        /// <summary>
        ///   Saudi Arabia
        /// </summary>
        SAR,

        /// <summary>
        ///   Seychelles
        /// </summary>
        SCR,

        /// <summary>
        ///   Sweden
        /// </summary>
        SEK,

        /// <summary>
        ///   Singapore
        /// </summary>
        SGD,

        /// <summary>
        ///   St.Helena
        /// </summary>
        SKP,

        /// <summary>
        ///   Thailand
        /// </summary>
        THB,

        /// <summary>
        ///   Turkey
        /// </summary>
        TRL,

        /// <summary>
        ///   Trinidad and Tobago
        /// </summary>
        TTD,

        /// <summary>
        ///   Taiwan
        /// </summary>
        TWD,

        /// <summary>
        ///   United States of America
        /// </summary>
        USD,

        /// <summary>
        ///   Venezuela
        /// </summary>
        VEB,

        /// <summary>
        ///   Viet-Nam
        /// </summary>
        VND,

        /// <summary>
        ///   Europe (States of the European Union)
        /// </summary>
        XEU,

        /// <summary>
        ///   South Africa
        /// </summary>
        ZAR,

        /// <summary>
        ///   Zimbabwe
        /// </summary>
        ZWD,
        NOK
    }
}