﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Xbim.Ifc2x3.MeasureResource;
using Xbim.XbimExtensions;
using Xbim.XbimExtensions.Interfaces;

namespace Xbim.Ifc2x3.MaterialPropertyResource
{
    /// <summary>
    /// Common definition to capture the properties of products of combustion generated by elements typically used within the context of building services and flow distribution systems.
    /// </summary>
    [IfcPersistedEntity]
    public class IfcProductsOfCombustionProperties : IfcMaterialProperties
    {
        private IfcSpecificHeatCapacityMeasure? _SpecificHeatCapacity;


        ///<summary>
        /// Specific heat of the products of combustion: heat energy absorbed per temperature unit. Usually measured in [J/kg K]. 
        /// </summary>
        [IfcAttribute(2, IfcAttributeState.Optional)]
        public IfcSpecificHeatCapacityMeasure? SpecificHeatCapacity
        {
            get
            {
                ((IPersistIfcEntity)this).Activate(false);
                return _SpecificHeatCapacity;
            }
            set { this.SetModelValue(this, ref _SpecificHeatCapacity, value, v => SpecificHeatCapacity = v, "SpecificHeatCapacity"); }
        }

        private IfcPositiveRatioMeasure? _N20Content;

        /// <summary>
        ///  	Nitrous Oxide (N2O) content of the products of combustion. This is measured in weight of N2O per unit weight and is therefore unitless. 
        /// </summary>
        [IfcAttribute(3, IfcAttributeState.Optional)]
        public IfcPositiveRatioMeasure? N20Content
        {
            get
            {
                ((IPersistIfcEntity)this).Activate(false);
                return _N20Content;
            }
            set { this.SetModelValue(this, ref _N20Content, value, v => N20Content = v, "N20Content"); }
        }

        private IfcPositiveRatioMeasure? _COContent;

        /// <summary>
        /// Carbon monoxide (CO) content of the products of combustion.This is measured in weight of CO per unit weight and is therefore unitless. 
        /// </summary>
        [IfcAttribute(4, IfcAttributeState.Optional)]
        public IfcPositiveRatioMeasure? COContent
        {
            get
            {
                ((IPersistIfcEntity)this).Activate(false);
                return _COContent;
            }
            set { this.SetModelValue(this, ref _COContent, value, v => COContent = v, "COContent"); }
        }

        private IfcPositiveRatioMeasure? _CO2Content;

        /// <summary>
        /// Carbon Dioxide (CO2) content of the products of combustion. This is measured in weight of CO2 per unit weight and is therefore unitless.
        /// </summary>
        [IfcAttribute(5, IfcAttributeState.Optional)]
        public IfcPositiveRatioMeasure? CO2Content
        {
            get
            {
                ((IPersistIfcEntity)this).Activate(false);
                return _CO2Content;
            }
            set { this.SetModelValue(this, ref _CO2Content, value, v => CO2Content = v, "CO2Content"); }
        }

        public override void IfcParse(int propIndex, IPropertyValue value)
        {
            switch (propIndex)
            {
                case 0:
                    base.IfcParse(propIndex, value);
                    break;
                case 1:
                    _SpecificHeatCapacity = value.RealVal;
                    break;
                case 2:
                    _N20Content = value.RealVal;
                    break;
                case 3:
                    _COContent = value.RealVal;
                    break;
                case 4:
                    _CO2Content = value.RealVal;
                    break;
                default:
                    this.HandleUnexpectedAttribute(propIndex, value); break;
            }
        }
        
    }
}
