// Copyright (c) 2022 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=12556834893a7ae50b8f8bef2b71915fa1a141ca$
//

#include "libcef_dll/ctocpp/resource_bundle_handler_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
bool CefResourceBundleHandlerCToCpp::GetLocalizedString(int string_id,
                                                        CefString& string) {
  shutdown_checker::AssertNotShutdown();

  cef_resource_bundle_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, get_localized_string))
    return false;

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_localized_string(_struct, string_id,
                                              string.GetWritableStruct());

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefResourceBundleHandlerCToCpp::GetDataResource(int resource_id,
                                                     void*& data,
                                                     size_t& data_size) {
  shutdown_checker::AssertNotShutdown();

  cef_resource_bundle_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, get_data_resource))
    return false;

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval =
      _struct->get_data_resource(_struct, resource_id, &data, &data_size);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefResourceBundleHandlerCToCpp::GetDataResourceForScale(
    int resource_id,
    ScaleFactor scale_factor,
    void*& data,
    size_t& data_size) {
  shutdown_checker::AssertNotShutdown();

  cef_resource_bundle_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, get_data_resource_for_scale))
    return false;

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_data_resource_for_scale(
      _struct, resource_id, scale_factor, &data, &data_size);

  // Return type: bool
  return _retval ? true : false;
}

// CONSTRUCTOR - Do not edit by hand.

CefResourceBundleHandlerCToCpp::CefResourceBundleHandlerCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefResourceBundleHandlerCToCpp::~CefResourceBundleHandlerCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_resource_bundle_handler_t* CefCToCppRefCounted<
    CefResourceBundleHandlerCToCpp,
    CefResourceBundleHandler,
    cef_resource_bundle_handler_t>::UnwrapDerived(CefWrapperType type,
                                                  CefResourceBundleHandler* c) {
  NOTREACHED() << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType
    CefCToCppRefCounted<CefResourceBundleHandlerCToCpp,
                        CefResourceBundleHandler,
                        cef_resource_bundle_handler_t>::kWrapperType =
        WT_RESOURCE_BUNDLE_HANDLER;
