// Copyright (c) 2022 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=e2df55073d0fb809dcd4cf0f6bb7ed36dcd4f73c$
//

#include "libcef_dll/ctocpp/audio_handler_ctocpp.h"
#include "libcef_dll/cpptoc/browser_cpptoc.h"
#include "libcef_dll/shutdown_checker.h"

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
bool CefAudioHandlerCToCpp::GetAudioParameters(CefRefPtr<CefBrowser> browser,
                                               CefAudioParameters& params) {
  shutdown_checker::AssertNotShutdown();

  cef_audio_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, get_audio_parameters))
    return false;

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: browser; type: refptr_diff
  DCHECK(browser.get());
  if (!browser.get())
    return false;

  // Execute
  int _retval = _struct->get_audio_parameters(
      _struct, CefBrowserCppToC::Wrap(browser), &params);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
void CefAudioHandlerCToCpp::OnAudioStreamStarted(
    CefRefPtr<CefBrowser> browser,
    const CefAudioParameters& params,
    int channels) {
  shutdown_checker::AssertNotShutdown();

  cef_audio_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_audio_stream_started))
    return;

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: browser; type: refptr_diff
  DCHECK(browser.get());
  if (!browser.get())
    return;

  // Execute
  _struct->on_audio_stream_started(_struct, CefBrowserCppToC::Wrap(browser),
                                   &params, channels);
}

NO_SANITIZE("cfi-icall")
void CefAudioHandlerCToCpp::OnAudioStreamPacket(CefRefPtr<CefBrowser> browser,
                                                const float** data,
                                                int frames,
                                                int64 pts) {
  shutdown_checker::AssertNotShutdown();

  cef_audio_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_audio_stream_packet))
    return;

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: browser; type: refptr_diff
  DCHECK(browser.get());
  if (!browser.get())
    return;
  // Verify param: data; type: simple_byaddr
  DCHECK(data);
  if (!data)
    return;

  // Execute
  _struct->on_audio_stream_packet(_struct, CefBrowserCppToC::Wrap(browser),
                                  data, frames, pts);
}

NO_SANITIZE("cfi-icall")
void CefAudioHandlerCToCpp::OnAudioStreamStopped(
    CefRefPtr<CefBrowser> browser) {
  shutdown_checker::AssertNotShutdown();

  cef_audio_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_audio_stream_stopped))
    return;

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: browser; type: refptr_diff
  DCHECK(browser.get());
  if (!browser.get())
    return;

  // Execute
  _struct->on_audio_stream_stopped(_struct, CefBrowserCppToC::Wrap(browser));
}

NO_SANITIZE("cfi-icall")
void CefAudioHandlerCToCpp::OnAudioStreamError(CefRefPtr<CefBrowser> browser,
                                               const CefString& message) {
  shutdown_checker::AssertNotShutdown();

  cef_audio_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_audio_stream_error))
    return;

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: browser; type: refptr_diff
  DCHECK(browser.get());
  if (!browser.get())
    return;
  // Verify param: message; type: string_byref_const
  DCHECK(!message.empty());
  if (message.empty())
    return;

  // Execute
  _struct->on_audio_stream_error(_struct, CefBrowserCppToC::Wrap(browser),
                                 message.GetStruct());
}

// CONSTRUCTOR - Do not edit by hand.

CefAudioHandlerCToCpp::CefAudioHandlerCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefAudioHandlerCToCpp::~CefAudioHandlerCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_audio_handler_t*
CefCToCppRefCounted<CefAudioHandlerCToCpp,
                    CefAudioHandler,
                    cef_audio_handler_t>::UnwrapDerived(CefWrapperType type,
                                                        CefAudioHandler* c) {
  NOTREACHED() << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCToCppRefCounted<CefAudioHandlerCToCpp,
                                   CefAudioHandler,
                                   cef_audio_handler_t>::kWrapperType =
    WT_AUDIO_HANDLER;
