// Copyright (c) 2022 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=4015c7179f87d58159252275559c0a11ee9958c7$
//

#include "libcef_dll/cpptoc/test/test_server_connection_cpptoc.h"
#include "libcef_dll/shutdown_checker.h"
#include "libcef_dll/transfer_util.h"

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

void CEF_CALLBACK test_server_connection_send_http200response(
    struct _cef_test_server_connection_t* self,
    const cef_string_t* content_type,
    const void* data,
    size_t data_size) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self)
    return;
  // Verify param: content_type; type: string_byref_const
  DCHECK(content_type);
  if (!content_type)
    return;
  // Verify param: data; type: simple_byaddr
  DCHECK(data);
  if (!data)
    return;

  // Execute
  CefTestServerConnectionCppToC::Get(self)->SendHttp200Response(
      CefString(content_type), data, data_size);
}

void CEF_CALLBACK test_server_connection_send_http404response(
    struct _cef_test_server_connection_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self)
    return;

  // Execute
  CefTestServerConnectionCppToC::Get(self)->SendHttp404Response();
}

void CEF_CALLBACK test_server_connection_send_http500response(
    struct _cef_test_server_connection_t* self,
    const cef_string_t* error_message) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self)
    return;
  // Verify param: error_message; type: string_byref_const
  DCHECK(error_message);
  if (!error_message)
    return;

  // Execute
  CefTestServerConnectionCppToC::Get(self)->SendHttp500Response(
      CefString(error_message));
}

void CEF_CALLBACK test_server_connection_send_http_response(
    struct _cef_test_server_connection_t* self,
    int response_code,
    const cef_string_t* content_type,
    const void* data,
    size_t data_size,
    cef_string_multimap_t extra_headers) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self)
    return;
  // Verify param: content_type; type: string_byref_const
  DCHECK(content_type);
  if (!content_type)
    return;
  // Verify param: data; type: simple_byaddr
  DCHECK(data);
  if (!data)
    return;
  // Unverified params: extra_headers

  // Translate param: extra_headers; type: string_map_multi_byref_const
  std::multimap<CefString, CefString> extra_headersMultimap;
  transfer_string_multimap_contents(extra_headers, extra_headersMultimap);

  // Execute
  CefTestServerConnectionCppToC::Get(self)->SendHttpResponse(
      response_code, CefString(content_type), data, data_size,
      extra_headersMultimap);
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefTestServerConnectionCppToC::CefTestServerConnectionCppToC() {
  GetStruct()->send_http200response =
      test_server_connection_send_http200response;
  GetStruct()->send_http404response =
      test_server_connection_send_http404response;
  GetStruct()->send_http500response =
      test_server_connection_send_http500response;
  GetStruct()->send_http_response = test_server_connection_send_http_response;
}

// DESTRUCTOR - Do not edit by hand.

CefTestServerConnectionCppToC::~CefTestServerConnectionCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefTestServerConnection> CefCppToCRefCounted<
    CefTestServerConnectionCppToC,
    CefTestServerConnection,
    cef_test_server_connection_t>::UnwrapDerived(CefWrapperType type,
                                                 cef_test_server_connection_t*
                                                     s) {
  NOTREACHED() << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefTestServerConnectionCppToC,
                                   CefTestServerConnection,
                                   cef_test_server_connection_t>::kWrapperType =
    WT_TEST_SERVER_CONNECTION;
