/*
* Copyright (C) 2007  Haris Kurtagic
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of version 2.1 of the GNU Lesser
* General Public License as published by the Free Software Foundation.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "c_KgMssApplySchema.h"

c_KgMssApplySchema::c_KgMssApplySchema(c_KgMssConnection *Conn)
  : c_KgMssFdoCommand(Conn)
{
  m_IngoreStates = true;
}

c_KgMssApplySchema::~c_KgMssApplySchema(void)
{
}


/// \brief
/// Gets the name of the schema to create.
/// 
/// \return
/// Returns the name of the schema to create
/// 
FdoFeatureSchema* c_KgMssApplySchema::GetFeatureSchema()
{
  return FDO_SAFE_ADDREF(m_FeatureSchema.p);
}

/// \brief
/// Sets the name of the schema to create.
/// 
/// \param value 
/// Input the name of the schema to create
/// 
/// \return
/// Returns nothing
/// 
void c_KgMssApplySchema::SetFeatureSchema(FdoFeatureSchema* Schema)
{
  m_FeatureSchema = Schema;
  FDO_SAFE_ADDREF(m_FeatureSchema.p);
}

/// \brief
///  Gets the FdoPhysicalSchemaMapping used to specify how the schema definition
/// gets mapped into physical storage.
/// 
/// \return
/// Returns FdoPhysicalSchemaMapping
/// 
FdoPhysicalSchemaMapping* c_KgMssApplySchema::GetPhysicalMapping()
{
  return FDO_SAFE_ADDREF(m_PhysMapping.p);
}

/// \brief
/// Sets the FdoPhysicalSchemaMapping used to specify how the schema definition
/// gets mapped into physical storage.
/// 
/// \param value 
/// Input the FdoPhysicalSchemaMapping
/// 
/// \return
/// Returns nothing
/// 
void c_KgMssApplySchema::SetPhysicalMapping(FdoPhysicalSchemaMapping* PhysMap)
{
  m_PhysMapping = PhysMap;
  FDO_SAFE_ADDREF(m_PhysMapping.p);
}

/// \brief
///  Indicates whether Execute() will ignore element states 
/// when applying the feature schema.
/// 
/// \return
/// Returns true if elements states will be ignored, false otherwise. 
/// 
///  
FdoBoolean c_KgMssApplySchema::GetIgnoreStates()
{
  return m_IngoreStates;
}

/// \brief
/// Changes the handling of element states by Execute().
/// 
/// \param ignoreStates 
/// Input True: Execute() will ignore the 
/// element states on the Feature Schema elements. Instead, it 
/// will additively merge the Feature Schema into the current DataStore.
/// False: Execute() will use the element states to determine whether
/// each element is inserted, modified or deleted.
/// 
/// \return
/// Returns nothing
/// 
void c_KgMssApplySchema::SetIgnoreStates( FdoBoolean IgnoreStates )
{
  m_IngoreStates = IgnoreStates;
}



/// \brief
/// Executes the ApplySchema command that creates metadata and physical
/// storage for the schema. An exception is thrown if the schema already
/// exists or if a schema already exists and the feature provider only
/// supports a single schema. If schema changes include deletion of classes
/// or the schema itself, then those classes (or the schema, if it is marked
/// as deleted) must not contain any instance data. If they do, an exception
/// will be thrown.
/// Implementors must call FdoFeatureSchema::AcceptChanges() when Execute() succeeds.
/// It must be called after the schema has been successfully applied, in
/// order to synchronize the states of the schema elements.
/// 
/// \return
/// Returns nothing
/// 
void c_KgMssApplySchema::Execute()
{
  if( !m_IngoreStates ) 
    throw FdoException::Create(L"c_KgMssApplySchema::Execute Supports only IgnoreStates='true'");
    
  if( !m_FeatureSchema.p ) return;
 

 

//    
try
{  
    
  FdoPtr<FdoClassCollection> classes = m_FeatureSchema->GetClasses();
  int classcount = classes->GetCount();
  for(int classind=0;classind<classcount;classind++)
  {
    FdoStringP sql_cols;
    FdoStringP sql_create;
    FdoPtr<FdoClassDefinition> classdef = classes->GetItem(classind);
 
  // for the class properties need to convert to oracle types
  // als check if there is an AutoGenerated Int field
    FdoPropertyDefinition* autoprop=NULL;
    sql_cols = "";
    FdoPtr<FdoPropertyDefinitionCollection> props = classdef->GetProperties();
    if( props.p && props->GetCount() )
    {
      
      FdoStringP sep;
      FdoStringP proporatype;
      int propcount = props->GetCount();
      for(int propind=0;propind<propcount;propind++)
      {
        FdoPtr<FdoPropertyDefinition> propdef = props->GetItem(propind);
        
        // add all columns exect geometry; geometry is added separately
        if( propdef->GetPropertyType() == FdoPropertyType_DataProperty )
        {
          FdoDataPropertyDefinition * propdata = (FdoDataPropertyDefinition *)propdef.p;
          proporatype = "";
          if( !c_FdoMss_API::FdoPropertyToMssDataType(propdef.p,proporatype) )
          {
            
            throw FdoCommandException::Create( L"c_KgMssApplySchema::Execute: Unkown Property Definition ");  
          }
          
          
          
          sql_cols = sql_cols + sep + " [" + propdef->GetName() + "] " + proporatype;
          
          /*
          if( propdata->GetIsAutoGenerated() && (propdata->GetDataType() == FdoDataType_Int32) )
          {
            sql_cols = sql_cols + " IDENTITY PRIMARY KEY ";
            autoprop = propdata;
          }
          */
          
          sep = ",";
        }
      }
    // create sql for creating the table  
      FdoStringP tablename = classdef->GetName();
      
      
      // add oid column as identiy and primary key
      // just check name of oid, if exist create oid2 or oid3 ...
      FdoStringP newident;
      {
        FdoStringP templ,num;
        templ = "oid";
        
        newident = templ;
        
        int ind=2;
        bool nameexist=true;
        while( nameexist && (ind<12345) )
        {
          nameexist=false;
          int propcount = props->GetCount();
          for(int propind=0;propind<propcount;propind++)
          {
            FdoPtr<FdoPropertyDefinition> propdef = props->GetItem(propind);
            if( newident.ICompare(propdef->GetName()) == 0 )
            {
              nameexist=true;
              break;
            }
          }
          
          if( nameexist )
          {
            num.Format(L"%d",ind); 
            newident = templ + num;
            ind++;
          }
        }
      }
      
      if( autoprop )
      {
      // identity is alreday added
        sql_create = sql_create + "CREATE TABLE [" + tablename + "] ( " + sql_cols + " ) ";
      }
      else
      {
      // add an new identity
        sql_create = sql_create + "CREATE TABLE [" + tablename + "] ( " + newident + " INTEGER IDENTITY PRIMARY KEY, " + sql_cols + " ) ";
      }
      
      string sqlstr = sql_create;
      const char*dbg = sqlstr.c_str();
      
      m_Connection->OTL_ExecuteSql(dbg);
      
      // Now need to call SQL procedure ST.AddGeometryColumn
      {
       int propcount = props->GetCount();
      for(int propind=0;propind<propcount;propind++)
      {
        FdoPtr<FdoPropertyDefinition> propdef = props->GetItem(propind);
        
        // add all columns exect geometry; geometry is added separately
        if( propdef->GetPropertyType() == FdoPropertyType_GeometricProperty )
        {
          FdoGeometricPropertyDefinition* geomprop = (FdoGeometricPropertyDefinition*)propdef.p;
          if( geomprop )
          {
            
            
            FdoStringP msstype;
            c_FdoMss_API::FdoGeomTypesToMssGeomType(geomprop,msstype);
            
            
            char buff [2048];
            FdoStringP gname = geomprop->GetName();
            sprintf(buff," execute ST.AddGeometryColumn '%s','%s','%s',%d,'%s';","dbo",(const char*)tablename,(const char*)gname,-1,(const char*)msstype);
            m_Connection->OTL_ExecuteSql(buff);  
          }
        }
      }
      }
      /*
      if( classdef->GetClassType() == FdoClassType_FeatureClass )
      {
        FdoFeatureClass* fclass = (FdoFeatureClass*)classdef.p;
        FdoPtr<FdoGeometricPropertyDefinition> geomprop =  fclass->GetGeometryProperty();
        if( geomprop.p )
        {
          char buff [2048];
          FdoStringP gname = geomprop->GetName();
          sprintf(buff," execute ST.AddGeometryColumn '%s','%s','%s',%d,'%s';","dbo",(const char*)tablename,(const char*)gname,0,"GEOMETRY");
          m_Connection->OTL_ExecuteSql(buff);  
        }
      }
      */
                    
    }
    
  }
  
  
}
catch(c_KgOtlException& ea)
{
  throw FdoCommandException::Create( ea.what() );    
}  

    
}//endof c_KgMssApplySchema::Execute

/*
void c_KgMssApplySchema::InsertSdoGeomMetadata(FdoString* TableName,FdoGeometricPropertyDefinition* GeomProp)
{
  FdoString* scname = GeomProp->GetSpatialContextAssociation();
        
  FdoPtr<c_KgMssSpatialContextCollection> sccol = m_Connection->GetSpatialContexts();
  FdoPtr<c_KgMssSpatialContext> spcontext = sccol->FindItem(scname);
  
  bool isgeogcs=false;
  
  c_KgMssSridDesc orasrid;
  if( spcontext.p ) orasrid = spcontext->GetOraSridDesc();
  
  
  
  double xlow = D_SPATIALCONTEXT_DEFAULT_MINX;
  double xup = D_SPATIALCONTEXT_DEFAULT_MAXX;
  double ylow = D_SPATIALCONTEXT_DEFAULT_MINY;
  double yup = D_SPATIALCONTEXT_DEFAULT_MAXY;
  double zlow = D_SPATIALCONTEXT_DEFAULT_MINZ;
  double zup = D_SPATIALCONTEXT_DEFAULT_MAXZ;
  double mlow = D_SPATIALCONTEXT_DEFAULT_MINM;
  double mup = D_SPATIALCONTEXT_DEFAULT_MAXM;
  
  double xytol = D_SPATIALCONTEXT_DEFAULT_XY_TOLERANCE;
  double ztol = D_SPATIALCONTEXT_DEFAULT_Z_TOLERANCE;
  double mtol = D_SPATIALCONTEXT_DEFAULT_M_TOLERANCE;
  
  if( spcontext.p )
  {
    xytol = spcontext->GetXYTolerance();
    ztol = spcontext->GetZTolerance();
    
    FdoStringP wkt = spcontext->GetCoordinateSystemWkt();
    
    if( c_Ora_API::IsGeodeticCoordSystem(wkt) )
    {
      xlow = -180.0;
      xup = 180.0;
      ylow = -90.0;
      yup = 90.0;
      isgeogcs = true;
    }

  }
  else
  {
    isgeogcs = false;
    xytol = D_SPATIALCONTEXT_DEFAULT_XY_TOLERANCE;
    ztol = D_SPATIALCONTEXT_DEFAULT_Z_TOLERANCE;
    orasrid.m_OraSrid = 0;
    orasrid.m_IsGeodetic = false;
  }
  
  if( ztol <= 0.0 ) ztol = D_SPATIALCONTEXT_DEFAULT_Z_TOLERANCE;
  if( xytol <= 0.0 ) xytol = D_SPATIALCONTEXT_DEFAULT_XY_TOLERANCE;
  
  FdoStringP sqlstr,xdim,ydim,zdim,mdim;
  
  FdoStringP geomname = GeomProp->GetName();
  
  
  FdoStringP tabname = TableName;
  
  sqlstr = "INSERT INTO USER_SDO_GEOM_METADATA VALUES ( '";
  sqlstr = sqlstr + tabname.Upper() + "' , '" + geomname.Upper() + "'";
  sqlstr = sqlstr + ",MDSYS.SDO_DIM_ARRAY(";
  
  wchar_t tempbuff[1024];
  
  if( isgeogcs )
  {
    
    //xdim = FdoStringP::Format(L"MDSYS.SDO_DIM_ELEMENT('LAT', %lf, %lf, %lf)",xlow,xup,xytol);
    swprintf(tempbuff,1000,L"MDSYS.SDO_DIM_ELEMENT('LAT', %lf, %lf, %lf)",xlow,xup,xytol);
    xdim =  tempbuff;
  }
  else
  {
    //xdim = FdoStringP::Format(L"MDSYS.SDO_DIM_ELEMENT('X', %lf, %lf, %lf)",xlow,xup,xytol);
    swprintf(tempbuff,1000,L"MDSYS.SDO_DIM_ELEMENT('X', %lf, %lf, %lf)",xlow,xup,xytol);
    xdim =  tempbuff;
  }
    
  sqlstr = sqlstr + xdim;
    
  if( isgeogcs )
  {
    //ydim = FdoStringP::Format(L"MDSYS.SDO_DIM_ELEMENT('LON', %lf, %lf, %lf)",ylow,yup,xytol);
    swprintf(tempbuff,1000,L"MDSYS.SDO_DIM_ELEMENT('LON', %lf, %lf, %lf)",ylow,yup,xytol);
    ydim = tempbuff;
  }
  else
  {
    swprintf(tempbuff,1000,L"MDSYS.SDO_DIM_ELEMENT('Y', %lf, %lf, %lf)",ylow,yup,xytol);    
    ydim = tempbuff;
  }
    
  sqlstr = sqlstr + "," + ydim;    
  
  if( GeomProp->GetHasElevation() )
  {
    swprintf(tempbuff,1000,L"MDSYS.SDO_DIM_ELEMENT('Z', %lf, %lf, %lf)",zlow,zup,ztol);
    zdim = tempbuff;
    sqlstr = sqlstr + "," + zdim;    
  }
  if( GeomProp->GetHasMeasure() )
  {
    swprintf(tempbuff,1000,L"MDSYS.SDO_DIM_ELEMENT('M', %lf, %lf, %lf)",mlow,mup,mtol);
    mdim = tempbuff;
    sqlstr = sqlstr + "," + mdim;    
  }
  sqlstr = sqlstr + ")";
  
  FdoStringP sridstr;
  if( orasrid.m_OraSrid > 0 )
    sridstr = FdoStringP::Format(L"%ld",orasrid);
  else
    sridstr = "NULL";
    
  sqlstr = sqlstr + "," + sridstr + ")";
  
  oracle::occi::Statement* occi_stm=NULL;
try
{
  occi_stm = m_Connection->OCCI_CreateStatement();
  
  string sstr = sqlstr;
  occi_stm->executeUpdate(sstr);
  
  m_Connection->OCCI_TerminateStatement(occi_stm);
}
catch(c_KgOtlException& ea)
{
  if( occi_stm ) m_Connection->OCCI_TerminateStatement(occi_stm);
  
  FdoStringP gstr = ea.what();
  throw FdoCommandException::Create( gstr );    
}    

}//end of c_KgMssApplySchema::InsertSdoGeomMetadata
*/

/*
void c_KgMssApplySchema::InsertSdoGeomMetadata(FdoString* TableName,FdoGeometricPropertyDefinition* GeomProp)
{
  FdoString* scname = GeomProp->GetSpatialContextAssociation();
        
  FdoPtr<c_KgMssSpatialContextCollection> sccol = m_Connection->GetSpatialContexts();
  FdoPtr<c_KgMssSpatialContext> spcontext = sccol->FindItem(scname);
  
  bool isgeogcs=false;
  
  c_KgMssSridDesc orasrid;
  if( spcontext.p ) orasrid = spcontext->GetOraSridDesc();
  
  
  
  double xlow = D_SPATIALCONTEXT_DEFAULT_MINX;
  double xup = D_SPATIALCONTEXT_DEFAULT_MAXX;
  double ylow = D_SPATIALCONTEXT_DEFAULT_MINY;
  double yup = D_SPATIALCONTEXT_DEFAULT_MAXY;
  double zlow = D_SPATIALCONTEXT_DEFAULT_MINZ;
  double zup = D_SPATIALCONTEXT_DEFAULT_MAXZ;
  double mlow = D_SPATIALCONTEXT_DEFAULT_MINM;
  double mup = D_SPATIALCONTEXT_DEFAULT_MAXM;
  
  double xytol = D_SPATIALCONTEXT_DEFAULT_XY_TOLERANCE;
  double ztol = D_SPATIALCONTEXT_DEFAULT_Z_TOLERANCE;
  double mtol = D_SPATIALCONTEXT_DEFAULT_M_TOLERANCE;
  
  if( spcontext.p )
  {
    xytol = spcontext->GetXYTolerance();
    ztol = spcontext->GetZTolerance();
    
    FdoStringP wkt = spcontext->GetCoordinateSystemWkt();
    
    if( c_Ora_API::IsGeodeticCoordSystem(wkt) )
    {
      xlow = -180.0;
      xup = 180.0;
      ylow = -90.0;
      yup = 90.0;
      isgeogcs = true;
    }

  }
  else
  {
    isgeogcs = false;
    xytol = D_SPATIALCONTEXT_DEFAULT_XY_TOLERANCE;
    ztol = D_SPATIALCONTEXT_DEFAULT_Z_TOLERANCE;
    orasrid.m_OraSrid = 0;
    orasrid.m_IsGeodetic = false;
  }
  
  if( ztol <= 0.0 ) ztol = D_SPATIALCONTEXT_DEFAULT_Z_TOLERANCE;
  if( xytol <= 0.0 ) xytol = D_SPATIALCONTEXT_DEFAULT_XY_TOLERANCE;
  
  FdoStringP sqlstr,xdim,ydim,zdim,mdim;
  
  FdoStringP geomname = GeomProp->GetName();
  
  
  FdoStringP tabname = TableName;
  
  sqlstr = "INSERT INTO USER_SDO_GEOM_METADATA VALUES ( '";
  sqlstr = sqlstr + tabname.Upper() + "' , '" + geomname.Upper() + "'";
  sqlstr = sqlstr + ",MDSYS.SDO_DIM_ARRAY(";
  
  //wchar_t tempbuff[1024];
  
  SDO_DIM_ELEMENT *xdim_sdoelem = new SDO_DIM_ELEMENT;
  if( isgeogcs )
    xdim_sdoelem->setSdo_dimname("LAT");
  else
    xdim_sdoelem->setSdo_dimname("X");
  xdim_sdoelem->setSdo_lb(xlow);
  xdim_sdoelem->setSdo_ub(xup);
  xdim_sdoelem->setSdo_tolerance(xytol);
  
  
  xdim = L":1";
    
  sqlstr = sqlstr + xdim;
    
  SDO_DIM_ELEMENT *ydim_sdoelem = new SDO_DIM_ELEMENT;
  if( isgeogcs )
    ydim_sdoelem->setSdo_dimname("LON");
  else
    ydim_sdoelem->setSdo_dimname("Y");
  ydim_sdoelem->setSdo_lb(xlow);
  ydim_sdoelem->setSdo_ub(xup);
  ydim_sdoelem->setSdo_tolerance(xytol);
  
  ydim = L":2";
    
  sqlstr = sqlstr + "," + ydim;    
  
  SDO_DIM_ELEMENT *zdim_sdoelem=NULL;
  if( GeomProp->GetHasElevation() )
  {
    zdim_sdoelem = new SDO_DIM_ELEMENT;
    zdim_sdoelem->setSdo_dimname("Z");
    zdim_sdoelem->setSdo_lb(zlow);
    zdim_sdoelem->setSdo_ub(zup);
    zdim_sdoelem->setSdo_tolerance(ztol);
    
    sqlstr = sqlstr + "," + ":3";    
  }
  
  SDO_DIM_ELEMENT *mdim_sdoelem=NULL;
  if( GeomProp->GetHasMeasure() )
  {
    //swprintf(tempbuff,1000,L"MDSYS.SDO_DIM_ELEMENT('M', %lf, %lf, %lf)",mlow,mup,mtol);
    //mdim = tempbuff;
    
    mdim_sdoelem = new SDO_DIM_ELEMENT;
    mdim_sdoelem->setSdo_dimname("M");
    mdim_sdoelem->setSdo_lb(mlow);
    mdim_sdoelem->setSdo_ub(mup);
    mdim_sdoelem->setSdo_tolerance(mtol);
    
    if( zdim_sdoelem )
      sqlstr = sqlstr + "," + ":4";    
    else
      sqlstr = sqlstr + "," + ":3";    
    
  }
  sqlstr = sqlstr + ")";
  
  FdoStringP sridstr;
  if( orasrid.m_OraSrid > 0 )
    sridstr = FdoStringP::Format(L"%ld",orasrid);
  else
    sridstr = "NULL";
    
  sqlstr = sqlstr + "," + sridstr + ")";
  
  oracle::occi::Statement* occi_stm=NULL;
try
{
  occi_stm = m_Connection->OCCI_CreateStatement();
  string sstr = sqlstr;
  occi_stm->setSQL(sstr);
  occi_stm->setObject(1,xdim_sdoelem);
  occi_stm->setObject(2,ydim_sdoelem);
  if( zdim_sdoelem && mdim_sdoelem )
  {
    occi_stm->setObject(3,zdim_sdoelem);
    occi_stm->setObject(4,mdim_sdoelem);
  }
  else
  {
    if( zdim_sdoelem ) occi_stm->setObject(3,zdim_sdoelem);
    if( mdim_sdoelem ) occi_stm->setObject(3,zdim_sdoelem);    
  }
  
  occi_stm->executeUpdate();
  
  if( xdim_sdoelem ) delete xdim_sdoelem;
  if( ydim_sdoelem ) delete ydim_sdoelem;
  if( zdim_sdoelem ) delete zdim_sdoelem;
  if( mdim_sdoelem ) delete mdim_sdoelem;
  
  m_Connection->OCCI_TerminateStatement(occi_stm);
}
catch(c_KgOtlException& ea)
{
  if( occi_stm ) m_Connection->OCCI_TerminateStatement(occi_stm);
  
  FdoStringP gstr = ea.what();
  throw FdoCommandException::Create( gstr );    
}    

}//end of c_KgMssApplySchema::InsertSdoGeomMetadata
*/
/*
void c_KgMssApplySchema::CreateIndex(FdoString* TableName,FdoGeometricPropertyDefinition* GeomProp)
{

  FdoStringP sqlstr;
  
  //"CREATE INDEX curvepolygon_sid ON curvepolygon ("GEOM") INDEXTYPE IS "MDSYS"."SPATIAL_INDEX" PARAMETERS ('sdo_indx_dims=2')"
  
  FdoStringP tabname = TableName;
  FdoStringP geomname= GeomProp->GetName();
  sqlstr = L"CREATE INDEX ";
  sqlstr = sqlstr + tabname.Upper() + "_sind ON "  + tabname.Upper() + " (\"" + geomname.Upper() + "\") INDEXTYPE IS ";
  sqlstr = sqlstr + "\"MDSYS\".\"SPATIAL_INDEX\" ";
  
  FdoStringP sqlstr_layer_gtype;
  FdoInt32 types = GeomProp->GetGeometryTypes();
  switch( types )
  {
    case FdoGeometricType_Point:
      sqlstr_layer_gtype = "MULTIPOINT";
    break;
    case FdoGeometricType_Curve:
      sqlstr_layer_gtype = "MULTILINE";
    break;
    case FdoGeometricType_Surface:
      sqlstr_layer_gtype = "MULTIPOLYGON";
    break;
    default:
      sqlstr_layer_gtype = "";
    break;
  }
  FdoStringP sqlstr_params;
  
  if( sqlstr_layer_gtype.GetLength() > 0 )
  {
    sqlstr_params = sqlstr_params.Format(L"PARAMETERS ('sdo_indx_dims=2 layer_gtype=%s')",(const wchar_t*)sqlstr_layer_gtype);
  }
  else
  {
    sqlstr_params = L"PARAMETERS ('sdo_indx_dims=2')";
  }
  sqlstr = sqlstr + sqlstr_params;
  
  oracle::occi::Statement* occi_stm=NULL;
  
try
{
  occi_stm = m_Connection->OCCI_CreateStatement();
  
  string sstr=sqlstr;
  
  occi_stm->executeUpdate(sstr);
  
  m_Connection->OCCI_TerminateStatement(occi_stm);
}
catch(c_KgOtlException& ea)
{
  if( occi_stm ) m_Connection->OCCI_TerminateStatement(occi_stm);
  
  FdoStringP gstr = ea.what();
  throw FdoCommandException::Create( gstr );    
}    

}//end of c_KgMssApplySchema::CreateIndex
*/

/*
void c_KgMssApplySchema::CreatePrimaryKey(FdoString* TableName,FdoDataPropertyDefinitionCollection* IdentPropColl)
{

  if( !IdentPropColl || IdentPropColl->GetCount() <= 0 )
  {
    return;    
  }
  
  FdoStringP sqlstr;
  
  FdoStringP cnames;
  FdoStringP sep;
  long colcount = IdentPropColl->GetCount();
  for(long ind=0;ind<colcount;ind++)
  {
    FdoPtr<FdoDataPropertyDefinition> dataprop = IdentPropColl->GetItem(ind);
    cnames = cnames + sep + dataprop->GetName();
    
    sep = L",";
  }
  
  FdoStringP pkeyname;
  pkeyname = TableName;
  pkeyname = pkeyname.Upper() + "_PK";
  sqlstr = sqlstr.Format(L"ALTER TABLE %s ADD CONSTRAINT %s primary key (%s)",(FdoString*)TableName,(FdoString*)pkeyname,(FdoString*)cnames);
  
 
  
  oracle::occi::Statement* occi_stm=NULL;
  
try
{
  occi_stm = m_Connection->OCCI_CreateStatement();
  
  string sstr=sqlstr;
  
  occi_stm->executeUpdate(sstr);
  
  m_Connection->OCCI_TerminateStatement(occi_stm);
}
catch(c_KgOtlException& ea)
{
  if( occi_stm ) m_Connection->OCCI_TerminateStatement(occi_stm);
  
  FdoStringP gstr = ea.what();
  throw FdoCommandException::Create( gstr );    
}    

}//end of c_KgMssApplySchema::CreatePrimaryKey
*/

/*
void c_KgMssApplySchema::CreateTableSequence(FdoString* TableName)
{


  
  FdoStringP sqlstr;
  
  sqlstr = sqlstr.Format(L"CREATE SEQUENCE %s_FDOSEQ",(FdoString*)TableName);
  
 
  
  oracle::occi::Statement* occi_stm=NULL;
  
try
{
  occi_stm = m_Connection->OCCI_CreateStatement();
  
  string sstr=sqlstr;
  
  occi_stm->executeUpdate(sstr);
  
  m_Connection->OCCI_TerminateStatement(occi_stm);
}
catch(c_KgOtlException& ea)
{
  if( occi_stm ) m_Connection->OCCI_TerminateStatement(occi_stm);
  
  FdoStringP gstr = ea.what();
  throw FdoCommandException::Create( gstr );    
}    

}//end of c_KgMssApplySchema::CreateTableSequence

*/