﻿#region XbimHeader

// The eXtensible Building Information Modelling (xBIM) Toolkit
// Solution:    XbimComplete
// Project:     Xbim.Ifc
// Filename:    IfcSIUnitName.cs
// Published:   01, 2012
// Last Edited: 9:04 AM on 20 12 2011
// (See accompanying copyright.rtf)

#endregion

namespace Xbim.Ifc2x3.MeasureResource
{
    /// <summary>
    ///   Name of the SI Unit
    /// </summary>
    public enum IfcSIUnitName
    {
        /// <summary>
        ///   Unit for electric current.
        /// </summary>
        AMPERE,

        /// <summary>
        ///   Unit for radioactivity.
        /// </summary>
        BECQUEREL,

        /// <summary>
        ///   Unit for luminousintensity.
        /// </summary>
        CANDELA,

        /// <summary>
        ///   Unit for electric charge.
        /// </summary>
        COULOMB,

        /// <summary>
        ///   Unit for volume.
        /// </summary>
        CUBIC_METRE,

        /// <summary>
        ///   Unit for thermodynamic temperature.
        /// </summary>
        DEGREE_CELSIUS,

        /// <summary>
        ///   Unit for electric capacitance.
        /// </summary>
        FARAD,

        /// <summary>
        ///   Unit for mass.
        /// </summary>
        GRAM,

        /// <summary>
        ///   Unit for absorbed radioactive dose.
        /// </summary>
        GRAY,

        /// <summary>
        ///   Unit for inductance.
        /// </summary>
        HENRY,

        /// <summary>
        ///   Unit for frequency.
        /// </summary>
        HERTZ,

        /// <summary>
        ///   Unit for energy.
        /// </summary>
        JOULE,

        /// <summary>
        ///   Unit for thermodynamic temperature.
        /// </summary>
        KELVIN,

        /// <summary>
        ///   Unit for luminous flux.
        /// </summary>
        LUMEN,

        /// <summary>
        ///   Unit for illuminance.
        /// </summary>
        LUX,

        /// <summary>
        ///   Unit for length.
        /// </summary>
        METRE,

        /// <summary>
        ///   Unit for amount of substance.
        /// </summary>
        MOLE,

        /// <summary>
        ///   Unit for force.
        /// </summary>
        NEWTON,

        /// <summary>
        ///   Unit for electric resistance.
        /// </summary>
        OHM,

        /// <summary>
        ///   Unit for pressure.
        /// </summary>
        PASCAL,

        /// <summary>
        ///   Unit for plane angle.
        /// </summary>
        RADIAN,

        /// <summary>
        ///   Unit for time.
        /// </summary>
        SECOND,

        /// <summary>
        ///   Unit for electric conductance.
        /// </summary>
        SIEMENS,

        /// <summary>
        ///   Unit for radioactive dose equivalent.
        /// </summary>
        SIEVERT,

        /// <summary>
        ///   Unit for area.
        /// </summary>
        SQUARE_METRE,

        /// <summary>
        ///   Unit for solid angle.
        /// </summary>
        STERADIAN,

        /// <summary>
        ///   Unit for magnetic flux density.
        /// </summary>
        TESLA,

        /// <summary>
        ///   Unit for electric voltage.
        /// </summary>
        VOLT,

        /// <summary>
        ///   Unit for power.
        /// </summary>
        WATT,

        /// <summary>
        ///   Unit for magnetic flux.
        /// </summary>
        WEBER
    }
}