// Copyright (c) 2022 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=ef632f8846499c0605300240a2ec7240a1750ce2$
//

#include "libcef_dll/ctocpp/run_file_dialog_callback_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"
#include "libcef_dll/transfer_util.h"

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
void CefRunFileDialogCallbackCToCpp::OnFileDialogDismissed(
    const std::vector<CefString>& file_paths) {
  shutdown_checker::AssertNotShutdown();

  cef_run_file_dialog_callback_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_file_dialog_dismissed))
    return;

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: file_paths

  // Translate param: file_paths; type: string_vec_byref_const
  cef_string_list_t file_pathsList = cef_string_list_alloc();
  DCHECK(file_pathsList);
  if (file_pathsList)
    transfer_string_list_contents(file_paths, file_pathsList);

  // Execute
  _struct->on_file_dialog_dismissed(_struct, file_pathsList);

  // Restore param:file_paths; type: string_vec_byref_const
  if (file_pathsList)
    cef_string_list_free(file_pathsList);
}

// CONSTRUCTOR - Do not edit by hand.

CefRunFileDialogCallbackCToCpp::CefRunFileDialogCallbackCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefRunFileDialogCallbackCToCpp::~CefRunFileDialogCallbackCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_run_file_dialog_callback_t* CefCToCppRefCounted<
    CefRunFileDialogCallbackCToCpp,
    CefRunFileDialogCallback,
    cef_run_file_dialog_callback_t>::UnwrapDerived(CefWrapperType type,
                                                   CefRunFileDialogCallback*
                                                       c) {
  NOTREACHED() << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType
    CefCToCppRefCounted<CefRunFileDialogCallbackCToCpp,
                        CefRunFileDialogCallback,
                        cef_run_file_dialog_callback_t>::kWrapperType =
        WT_RUN_FILE_DIALOG_CALLBACK;
