// Copyright (c) 2022 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=2ad630d884be7968333098308a5bb25c608a037e$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_MEDIA_OBSERVER_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_MEDIA_OBSERVER_CTOCPP_H_
#pragma once

#if !defined(BUILDING_CEF_SHARED)
#error This file can be included DLL-side only
#endif

#include <vector>
#include "include/capi/cef_media_router_capi.h"
#include "include/cef_media_router.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed DLL-side only.
class CefMediaObserverCToCpp
    : public CefCToCppRefCounted<CefMediaObserverCToCpp,
                                 CefMediaObserver,
                                 cef_media_observer_t> {
 public:
  CefMediaObserverCToCpp();
  virtual ~CefMediaObserverCToCpp();

  // CefMediaObserver methods.
  void OnSinks(const std::vector<CefRefPtr<CefMediaSink>>& sinks) override;
  void OnRoutes(const std::vector<CefRefPtr<CefMediaRoute>>& routes) override;
  void OnRouteStateChanged(CefRefPtr<CefMediaRoute> route,
                           ConnectionState state) override;
  void OnRouteMessageReceived(CefRefPtr<CefMediaRoute> route,
                              const void* message,
                              size_t message_size) override;
};

#endif  // CEF_LIBCEF_DLL_CTOCPP_MEDIA_OBSERVER_CTOCPP_H_
